function [Leader_score,Leader_pos,Convergence_curve]=CTGWO(SearchAgents_no,Max_iter,lb,ub,dim,fobj,Optimizer)

Create_Parameters_Ternary_GWO

%Nagents: Is the number of wolves to be used
%NIter: is the total number of iterations to run the algorithm
%dim: is a scalar representing the problem dimension
%fobj: is a string representing the fitness function

Nagents=SearchAgents_no;
NIter=Max_iter;


%this code is based on the paper

% E. Emary, Hossam M.Zawbaa, AboulElla Hassanien, Binary
% grey wolf optimization approaches for feature selection, Neurocomputing172(2016)371–381.

Alpha_score=inf;
Beta_score=inf;
Delta_score=inf;

Alpha_pos=zeros(1,dim);
Delta_pos=zeros(1,dim);
Beta_pos=zeros(1,dim);

% initialize position vector and score for the leader
Leader_pos=zeros(1,dim);
Leader_score=inf; %change this to -inf for maximization problems

lb=min(The_Three_Possible_Values);
ub=max(The_Three_Possible_Values);

%tic

%Initialize the positions of search agents
Positions=zeros(Nagents,dim);
for i=1:Nagents
    Positions(i,:)=circshift(repmat(The_Three_Possible_Values,1,floor(dim/length(The_Three_Possible_Values))), mod(i,4) );
end
% Positions
% pause

%toc

%pause

%tic

Set_Chaotic_Sequences=Generate_Set_Chaotic_Sequences(SearchAgents_no,NIter);
%%% Here above we set the last value of all sequences to 0.5.
%toc

Convergence_curve=zeros(1,Max_iter);

%%%% Display Objective function
%[X,Y,Z]=Compute_Values_For_Plot_Objective_Function(Optimizer,lb,ub,fobj);


l=0; % Loop counter
while l<NIter
    for i=1:size(Positions,1)
        fitness=feval(fobj,Positions(i,:));
        
        if fitness<=Alpha_score
            Alpha_score=fitness;
            Alpha_pos=Positions(i,:);
        end
        
        if fitness>Alpha_score && fitness<=Beta_score
            Beta_score=fitness;
            Beta_pos=Positions(i,:);
        end
        
        if fitness>Alpha_score && fitness>Beta_score && fitness<=Delta_score
            Delta_score=fitness;
            Delta_pos=Positions(i,:);
        end
    end
    
    Random1_index=ceil((size(Positions,1)) * rand);
    Random2_index=ceil((size(Positions,1)) * rand);
    
    
    Random1_pos=Positions(Random1_index,:);
    Random2_pos=Positions(Random2_index,:);
    
    
    
    for i=1:size(Positions,1)
        a=2*(1-(l+1)^power_for_a*(1/Max_iter^power_for_a))* (0.5 + Set_Chaotic_Sequences(i,l+1));
        
%        tic
        
        for j=1:size(Positions,2)            
           Positions(i,j)=Update_Position_TGWO(Alpha_pos(j),Beta_pos(j),Delta_pos(j),Random1_pos(j),Random2_pos(j),Positions(i,j),a,OptionMap,OptionBinary);
        end
        
%        toc
        
%        pause
                
        %         fprintf('%f:\t',Alpha_score);
        %         fprintf('%d',Alpha_pos(:));
        %         fprintf('\n');
    end
    l=l+1;
    Convergence_curve(l)=Alpha_score;
    Leader_score=Alpha_score;
    Leader_pos=Alpha_pos;
    
%    Plot_Objective_Function_And_Search_Agents(Optimizer,X,Y,Z,lb,ub,l,Positions,Leader_pos)
    
    %     figure(101)
    %     histogram(Positions)
    %     pause(0.1)
    
end


end




