function [Leader_score,Leader_pos,Convergence_curve]=BGWO(SearchAgents_no,Max_iter,lb,ub,dim,fobj,Optimizer)

%Nagents: Is the number of wolves to be used
%NIter: is the total number of iterations to run the algorithm
%dim: is a scalar representing the problem dimension
%fobj: is a string representing the fitness function

Nagents=SearchAgents_no;
NIter=Max_iter;


%this code is based on the paper

% E. Emary, Hossam M.Zawbaa, AboulElla Hassanien, Binary
% grey wolf optimization approaches for feature selection, Neurocomputing172(2016)371–381.

Alpha_score=inf;
Beta_score=inf;
Delta_score=inf;

Alpha_pos=zeros(1,dim);
Delta_pos=zeros(1,dim);
Beta_pos=zeros(1,dim);

% initialize position vector and score for the leader
Leader_pos=zeros(1,dim);
Leader_score=inf; %change this to -inf for maximization problems


%Initialize the positions of search agents
Positions=initialization(Nagents,dim,ub,lb);

Convergence_curve=zeros(1,Max_iter);



l=0; % Loop counter
while l<NIter
    for i=1:size(Positions,1)
        fitness=feval(fobj,Positions(i,:));
        
        if fitness<Alpha_score
            Alpha_score=fitness;
            Alpha_pos=Positions(i,:);
        end
        
        if fitness>Alpha_score && fitness<Beta_score
            Beta_score=fitness;
            Beta_pos=Positions(i,:);
        end
        
        if fitness>Alpha_score && fitness>Beta_score && fitness<Delta_score
            Delta_score=fitness;
            Delta_pos=Positions(i,:);
        end
    end
    
    
    a=2-l*((2)/NIter);
    
    for i=1:size(Positions,1)
        for j=1:size(Positions,2)
            
            r1=rand();
            r2=rand();
            
            A1=2*a*r1-a;
            C1=2*r2;
            
            D_alpha=abs(C1*Alpha_pos(j)-Positions(i,j));
            v1=Sigmoid_Fcn(-A1*D_alpha,[10, 0.5]);
            if v1<rand
                v1=0;
            else
                v1=1;
            end
            X1=(Alpha_pos(j)+v1)>=1;
            
            r1=rand();
            r2=rand();
            
            A2=2*a*r1-a;
            C2=2*r2;
            
            D_beta=abs(C2*Beta_pos(j)-Positions(i,j));
            v1=Sigmoid_Fcn(-A2*D_beta,[10 0.5]);
            if v1<rand
                v1=0;
            else
                v1=1;
            end
            
            X2=(Beta_pos(j)+v1)>=1 ;
            
            r1=rand();
            r2=rand();
            
            A3=2*a*r1-a;
            C3=2*r2;
            
            D_delta=abs(C3*Delta_pos(j)-Positions(i,j));
            v1=Sigmoid_Fcn(-A3*D_delta,[10 0.5]);%eq. 25
            if v1<rand
                v1=0;
            else
                v1=1;
            end
            X3=(Delta_pos(j)+v1)>=1;
            
            Positions(i,j)=CrossOver(X1,X2,X3); %equation 23 in paper
            
        end
%         fprintf('%f:\t',Alpha_score);
%         fprintf('%d',Alpha_pos(:));
%         fprintf('\n');
    end
    l=l+1;
    Convergence_curve(l)=Alpha_score;
    Leader_score=Alpha_score;
    Leader_pos=Alpha_pos;
    

    
    
end



