#import pandas as pd
#import numpy as np
#import matplotlib.pyplot as plt
#import os
#import cv2
#
#import random as rn
#from random import shuffle  
#from zipfile import ZipFile
#from PIL import Image
#
#from skimage import feature, color, data
#from sklearn.preprocessing import LabelEncoder
#
#from sklearn.model_selection import KFold, StratifiedKFold
#from sklearn.svm import LinearSVC, SVC
#from sklearn.metrics import confusion_matrix, accuracy_score, classification_report
#from sklearn.model_selection import GridSearchCV
#import pickle
#from sklearn.preprocessing import StandardScaler, MinMaxScaler, normalize
#from sklearn.model_selection import train_test_split
#
#import time 
#


#from localbinarypatterns import LocalBinaryPatterns



import os

import random
import numpy 
import math
import time 
from fractions import Fraction

import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import cv2


import random as rn
from random import shuffle  
from zipfile import ZipFile
from PIL import Image

from skimage import feature, color, data
from sklearn.preprocessing import LabelEncoder

from sklearn.model_selection import KFold, StratifiedKFold
from sklearn.metrics import confusion_matrix, accuracy_score, classification_report
from sklearn.svm import LinearSVC, SVC

from sklearn.model_selection import GridSearchCV
import pickle
from sklearn.preprocessing import StandardScaler, MinMaxScaler, normalize
from sklearn.model_selection import train_test_split

import pickle as serializer


###Hog_data_extractor function will get the hog feature from the given jpeg file

def hog_data_extractor(jpeg_path):
    print(jpeg_path)

    jpeg_data = cv2.imread(jpeg_path)
    
    #Size=cv2.size(jpeg_data)
    #print(Size)

    jpeg_data=cv2.resize(jpeg_data,(32,32)) #256,256 pixels_ 32,32 per_cell=(8, 8), 
    gray= cv2.cvtColor(jpeg_data, cv2.COLOR_BGR2GRAY)
    hog_data = feature.hog(gray, orientations=9, pixels_per_cell=(8, 8), 
                           cells_per_block=(4, 4), block_norm= 'L2')
    return hog_data



def SVC_Surrogate(x1,x2,kernel_String):


    if kernel_String=='rbf':
       x3=1
    elif kernel_String=='linear':
       x3=2
  

    
    #results= x1**2+x2**2+x3**2-2*x3 
    results=1 - (abs(math.tanh((x1-2*10**3)/10**3))+ abs(math.tanh((x2-10**(-3))/10**(-3))) + abs(math.tanh((x3-1))))


    return results

def Run_SVM_Surrogate(x):

    x1=x[0]
    x2=x[1]
    x3=round(x[2])

    if x3==1:
      kernel_String='rbf' 
    elif x3==2:
      kernel_String='linear' 
  

    Accuracy=SVC_Surrogate(x1,x2,kernel_String)    

    FRR=100*(1-Accuracy)


    return FRR

"""
timerStart=time.time() 
Accuracy=compute_svmacc(1000, 0.001, 'rbf')
FRR=100*(1-Accuracy)

timerEnd=time.time() 
executionTime=timerEnd-timerStart

print('FRR: ', FRR )
print('execution Time: ', executionTime)
"""

#print(100*(1-compute_svmacc(1000, 0.001, 'rbf')))
