from All_Progs.Test_Functions.Benchmarks import F1
from All_Progs.Optimizers.Mixed_GWO.Functions_Continuous_Ternary_GWO import *
from All_Progs.Optimizers.Mixed_GWO.Functions_Mixed_GWO import *
from All_Progs.Optimizers.Discrete_GWO.Functions_Discrete_GWO import *

from All_Progs.Optimizers.Continuous_GWO.Functions_GWO import *

from All_Progs.Optimizers.Binary_GWO.Functions_Binary_GWO import *
from All_Progs.Optimizers.Binary_GWO.Functions_Chaotic_Binary_GWO import *

# from All_Progs.Optimizers.Continuous_GWO.Functions_GWO import *
from All_Progs.Optimizers.Continuous_GWO.utils_GWO import *

from All_Progs.Optimizers.Ternary_GWO.Functions_Ternary_GWO import *
from All_Progs.Optimizers.Ternary_GWO.Functions_Chaotic_Ternary_GWO import *
from All_Progs.Optimizers.Ternary_GWO.Functions_Chaotic_Ternary_GWO import *
from All_Progs.Optimizers.Ternary_GWO.utils_Ternary import *

from All_Progs.Optimizers.Mixed_GWO.Functions_Continuous_Ternary_GWO import *

from All_Progs.Test_Functions.Benchmarks import *
from All_Progs.SetupFile import *
from All_Progs.Display_ResultsFile import *
from All_Progs.map_library import *

#from All_Progs.Test_Functions.Radar_Functions.benchmarks_mlp_par_frequences import *

import time


class solution:
    def __init__(self):
        self.best = 0
        self.bestIndividual = []
        self.convergence = []
        self.optimizer = ""
        self.objfname = ""
        self.startTime = 0
        self.endTime = 0
        self.executionTime = 0
        self.lb = 0
        self.ub = 0
        self.dim = 0
        self.popnum = 0
        self.maxiers = 0


def run_continu_ameliore():
    print('Setup')
    dim, lb, ub, PopulationSize, Iterations, Name_Result_Folder = setup()
    print("Nb iterations prevu:", Iterations)

    print('start GWO')
    # fitness_function
    # Mon_Critere
    x = GWO_continu_ameliore(F10, lb, ub, dim, PopulationSize, Iterations)

    Estimated_Optimal_Parameters = x.Optimal_Parameters

    Execution_Time = x.executionTime
    convergence = x.convergence
    Optimal_Score_Estimated = convergence[Iterations - 1]

    Display_Numerical_Results(Estimated_Optimal_Parameters, Optimal_Score_Estimated, Iterations, Execution_Time)

    Name_File = 'ConvergenceCurve'
    Display_Visual_Results(Estimated_Optimal_Parameters, convergence, Iterations, Execution_Time, Name_Result_Folder,
                           Name_File)


def run_discrete():
    print('Setup')
    dim, lb, ub, PopulationSize, Iterations, Name_Result_Folder = setup()
    print("Nb iterations prevu:", Iterations)

    print('start GWO')
    # fitness_function
    # Mon_Critere
    x = GWO_Discrete(F10, lb, ub, dim, PopulationSize, Iterations)

    Estimated_Optimal_Parameters = x.Optimal_Parameters

    Execution_Time = x.executionTime
    convergence = x.convergence
    Optimal_Score_Estimated = convergence[Iterations - 1]

    Display_Numerical_Results(Estimated_Optimal_Parameters, Optimal_Score_Estimated, Iterations, Execution_Time)

    Name_File = 'ConvergenceCurve'
    Display_Visual_Results(Estimated_Optimal_Parameters, convergence, Iterations, Execution_Time, Name_Result_Folder,
                           Name_File)


def run_binary():
    print('Setup')
    dim, lb, ub, PopulationSize, Iterations, Name_Result_Folder = binary_setup()
    print("Nb iterations prevu:", Iterations)

    print('start GWO')
    # fitness_function
    # Mon_Critere

    # F10(np.array([0, 1, 0]))
    x = GWO_binary(F10, lb, ub, dim, PopulationSize, Iterations)
    Execution_Time = x.executionTime
    convergence = x.convergence
    x1 = x.n1
    x2 = x.n2
    x3 = x.n3
    Optimal_Score_Estimated = convergence[Iterations - 1]

    Display_Numerical_Results(x1, x2, x3, Optimal_Score_Estimated, Iterations, Execution_Time)

    Name_File = 'ConvergenceCurve'
    Display_Visual_Results(x1, x2, x3, convergence, Iterations, Execution_Time, Name_Result_Folder, Name_File)


def run_chaotic_binary():
    print('Setup')
    dim, lb, ub, PopulationSize, Iterations, Name_Result_Folder = binary_setup()
    print("Nb iterations prevu:", Iterations)

    print('start GWO')
    # fitness_function
    # Mon_Critere

    # F10(np.array([0, 1, 0]))
    x = GWO_binary_chaotic(F10, lb, ub, dim, PopulationSize, Iterations)
    Execution_Time = x.executionTime
    convergence = x.convergence
    x1 = x.n1
    x2 = x.n2
    x3 = x.n3
    Optimal_Score_Estimated = convergence[Iterations - 1]

    Display_Numerical_Results(x1, x2, x3, Optimal_Score_Estimated, Iterations, Execution_Time)

    Name_File = 'ConvergenceCurve'
    Display_Visual_Results(x1, x2, x3, convergence, Iterations, Execution_Time, Name_Result_Folder, Name_File)


def run_binary_binarychaotic():
    print('Setup')
    dim, lb, ub, PopulationSize, Iterations, Name_Result_Folder = setup()
    print("Nb iterations prevu:", Iterations)

    print('start GWO')
    # fitness_function
    # Mon_Critere
    x = GWO_continu_ameliore(F10, lb, ub, dim, PopulationSize, Iterations)
    Execution_Time = x.executionTime
    convergence = x.convergence
    Optimal_Score_Estimated = convergence[Iterations - 1]

    plt.plot(convergence, label='continu')

    dim, lb, ub, PopulationSize, Iterations, Name_Result_Folder = binary_setup()

    x = GWO_binary(F10, lb, ub, dim, PopulationSize, Iterations)
    convergence = x.convergence
    Optimal_Score_Estimated = convergence[Iterations - 1]
    plt.plot(convergence, label='binary')

    x = GWO_binary_chaotic(F10, lb, ub, dim, PopulationSize, Iterations)
    convergence = x.convergence
    Optimal_Score_Estimated = convergence[Iterations - 1]
    plt.plot(convergence, label='chaos')
    plt.legend()

    plt.show()


def run_ternary():
    print('Setup')
    dim, lb, ub, PopulationSize, Iterations, Name_Result_Folder = setup()
    print("Nb iterations prevu:", Iterations)

    print('start GWO')
    # fitness_function
    # Mon_Critere
    x = GWO_continu_ameliore(F10, lb, ub, dim, PopulationSize, Iterations)
    Execution_Time = x.executionTime
    convergence = x.convergence
    Optimal_Score_Estimated = convergence[Iterations - 1]
    print(['Optimal score GWO continu: ', str(Optimal_Score_Estimated)])

    plt.plot(convergence, label='continu')

    dim, lb, ub, PopulationSize, Iterations, Name_Result_Folder = binary_setup()

    x = GWO_ternary(F10, lb, ub, dim, PopulationSize, Iterations)
    convergence = x.convergence
    Optimal_Score_Estimated = convergence[Iterations - 1]
    print(['Optimal score GWO ternary: ', str(Optimal_Score_Estimated)])

    plt.plot(convergence, label='ternary')

    x = GWO_ternary_chaotic(F10, lb, ub, dim, PopulationSize, Iterations)
    convergence = x.convergence
    Optimal_Score_Estimated = convergence[Iterations - 1]
    print(['Optimal score GWO ternary chaotic: ', str(Optimal_Score_Estimated)])

    plt.plot(convergence, label='chaotic ternary')
    plt.legend()

    plt.show()


def run_continuous_ternary():
    print('Setup')
    dim, lb, ub, PopulationSize, Iterations, Name_Result_Folder = setup()
    print("Nb iterations prevu:", Iterations)

    print('start GWO continuous ternary')
    # fitness_function
    # Mon_Critere

    Nb_Ternary_Unknowns = 2
    x = GWO_continuous_ternary(F1, lb, ub, dim, PopulationSize, Iterations, Nb_Ternary_Unknowns)

    Execution_Time = x.executionTime
    convergence = x.convergence
    x1 = x.n1
    x2 = x.n2
    x3 = x.n3
    Optimal_Score_Estimated = convergence[Iterations - 1]

    Display_Numerical_Results(x1, x2, x3, Optimal_Score_Estimated, Iterations, Execution_Time)

    Name_File = 'ConvergenceCurve'
    Display_Visual_Results(x1, x2, x3, convergence, Iterations, Execution_Time, Name_Result_Folder, Name_File)


def run_continuous_ternary_binary(Test_Function):
    print('Setup')
    dim, lb, ub, PopulationSize, Iterations, Name_Result_Folder = setup()
    print("Nb iterations prevu:", Iterations)

    print('start GWO continuous ternary')
    # fitness_function
    # Mon_Critere

    print('Les deux paramètres à changer pour passer du CBTGWO au GWO: ')
    # setup radar Flora
    Nb_Continuous_Unknowns = 1  # 1 221
    Nb_Ternary_Unknowns = 2  # 2  0

    # setup capes Meryeme
    Nb_Continuous_Unknowns = 3  # 1 221
    Nb_Ternary_Unknowns = 100  # 2  0

    x = GWO_continuous_ternary_binary(Test_Function, lb, ub, dim, PopulationSize, Iterations, Nb_Continuous_Unknowns,
                                      Nb_Ternary_Unknowns)

    Execution_Time = x.executionTime
    convergence = x.convergence
    Estimated_Optimal_Parameters = x.Optimal_Parameters

    x1 = x.n1
    x2 = x.n2
    x3 = x.n3
    x4 = x.n4

    Optimal_Score_Estimated = convergence[Iterations - 1]

    Display_Numerical_Results(Estimated_Optimal_Parameters, Optimal_Score_Estimated, Iterations, Execution_Time)

    Name_File = 'ConvergenceCurve'
    Display_Visual_Results(Estimated_Optimal_Parameters, convergence, Iterations, Execution_Time, Name_Result_Folder,
                           Name_File)


def Plot_Convergence_Curves(Iterations, convergence_curve1, convergence_curve2, convergence_curve3,
                            Name_Result_Folder, Name_File, Option_Semilogy):
    x_Axis = My_Vector(1, Iterations, 1)

    # fig = plt.figure()
    # plt.plot(x_Axis, convergence_curve1, 'b-+', x_Axis, convergence_curve2, 'r-+', x_Axis, convergence_curve3, 'b-o')

    fig, ax = plt.subplots()

    if Option_Semilogy == 0:
        ax.plot(x_Axis, convergence_curve1, 'b-+', label='GWO')
        ax.plot(x_Axis, convergence_curve2, 'r-+', label='amixedGWO')
        ax.plot(x_Axis, convergence_curve3, 'b-o', label='CBTGWO')
    else:
        ax.semilogy(x_Axis, convergence_curve1, 'b-+', label='GWO')
        ax.semilogy(x_Axis, convergence_curve2, 'r-+', label='amixedGWO')
        ax.semilogy(x_Axis, convergence_curve3, 'b-o', label='CBTGWO')

    Min_y = 0.75 * np.min([convergence_curve1[-1], convergence_curve2[-1], convergence_curve3[-1]])
    Max_y = 1.25 * np.max([convergence_curve1[0], convergence_curve2[0], convergence_curve3[0]])
    ax.set_ylim([Min_y, Max_y])
    leg = ax.legend(loc="upper right")
    ###

    # plt.title('')
    plt.ylabel('Criterion value')
    plt.xlabel('Iterations')
    # plt.legend()
    # plt.show()

    # Name_File = 'Three_Compared_Methods'
    wholeNameFile = Name_Result_Folder + Name_File
    # plt.savefig(wholeNameFile + '.eps', format='eps', dpi=1000)
    plt.savefig(wholeNameFile + '.png', format='png', dpi=200)
    # plt.show()
    plt.show(block=False)
    plt.pause(1)
    plt.close(fig)


def Extract_Results_Optimization_Method(x_Method, x_Method_Previous):
    convergence_curve = x_Method.convergence * x_Method_Previous.convergence
    x_Method.convergence = convergence_curve
    Geometric_Mean_score_Method = convergence_curve[- 1]
    return x_Method, Geometric_Mean_score_Method


def Compare_Method1_Method2_Method3(Method1, Method2, Method3, Test_Function):
    dim, lb, ub, PopulationSize, Iterations, Name_Result_Folder, dim_continuous, dim_ternary, nb_Runs = setup()

    Geometric_Mean_score_Method1 = 1
    Geometric_Mean_score_Method2 = 1
    Geometric_Mean_score_Method3 = 1

    x_Method1 = solution()
    x_Method1.convergence = numpy.ones(Iterations)
    x_Method2 = solution()
    x_Method2.convergence = numpy.ones(Iterations)
    x_Method3 = solution()
    x_Method3.convergence = numpy.ones(Iterations)

    for i in range(nb_Runs):
        print(['Run index ', str(i)])
        # time.sleep(2)
        x_Method1_Previous = x_Method1
        x_Method1 = Method1(Test_Function, lb, ub, dim, PopulationSize, Iterations)
        x_Method1, Geometric_Mean_score_Method1 = Extract_Results_Optimization_Method(x_Method1,
                                                                                      x_Method1_Previous)

        x_Method2_Previous = x_Method2
        x_Method2 = Method2(Test_Function, lb, ub, dim, PopulationSize, Iterations)
        x_Method2, Geometric_Mean_score_Method2 = Extract_Results_Optimization_Method(x_Method2,
                                                                                      x_Method2_Previous)

        x_Method3_Previous = x_Method3
        x_Method3 = Method3(Test_Function, lb, ub, dim, PopulationSize, Iterations, dim_continuous,
                            dim_ternary)
        x_Method3, Geometric_Mean_score_Method3 = Extract_Results_Optimization_Method(x_Method3,
                                                                                      x_Method3_Previous)

    Geometric_mean1 = Geometric_Mean_score_Method1 ** (1 / nb_Runs)
    Geometric_mean2 = Geometric_Mean_score_Method2 ** (1 / nb_Runs)
    Geometric_mean3 = Geometric_Mean_score_Method3 ** (1 / nb_Runs)

    x_Method1.convergence = numpy.power(x_Method1.convergence, (1 / nb_Runs))
    x_Method2.convergence = numpy.power(x_Method2.convergence, (1 / nb_Runs))
    x_Method3.convergence = numpy.power(x_Method3.convergence, (1 / nb_Runs))

    print(['Optimal score Test function', str(Test_Function), str(Method1), str(Geometric_mean1)])
    Display_Numerical_Results_Only(x_Method1)
    # Display_Numerical_and_Visual_Results(x_Method1, 'ConvergenceCurve1', Name_Result_Folder)
    print(['Optimal score Test function', str(Test_Function), str(Method2), str(Geometric_mean2)])
    Display_Numerical_Results_Only(x_Method2)
    # Display_Numerical_and_Visual_Results(x_Method2, 'ConvergenceCurve2', Name_Result_Folder)
    print(['Optimal score Test function', str(Test_Function), str(Method3), str(Geometric_mean3)])
    Display_Numerical_Results_Only(x_Method3)
    # Display_Numerical_and_Visual_Results(x_Method3, 'ConvergenceCurve3', Name_Result_Folder)

    print(['Optimal score Test function', str(Test_Function), str(Method1), str(Geometric_mean1)])
    print(['Optimal score Test function', str(Test_Function), str(Method2), str(Geometric_mean2)])
    print(['Optimal score Test function', str(Test_Function), str(Method3), str(Geometric_mean3)])

    return Geometric_mean1, Geometric_mean2, Geometric_mean3, x_Method1, x_Method2, x_Method3


def run_Compare_Method1_Method2_Method3(Test_Function):
    dim, lb, ub, PopulationSize, Iterations, Name_Result_Folder, dim_continuous, dim_ternary, nb_Runs = setup()
    print(['Nb agents', str(PopulationSize), 'Nb iterations', str(Iterations), 'nb Runs', str(nb_Runs)])

    Geometric_mean1, Geometric_mean2, Geometric_mean3, x_Method1, x_Method2, x_Method3 = Compare_Method1_Method2_Method3(
        GWO,  # ,  # GWO_continu_ameliore GWO_continuous_binary_Original
        GWO_Discrete,
        GWO_continuous_ternary_binary_memory,#        GWO_continuous_ternary_binary,
        Test_Function)

    convergence_curve1 = x_Method1.convergence
    convergence_curve2 = x_Method2.convergence
    convergence_curve3 = x_Method3.convergence

    Name_File = 'Three_Compared_Methods'
    Option_Semilogy = 0
    Plot_Convergence_Curves(Iterations, convergence_curve1, convergence_curve2, convergence_curve3, Name_Result_Folder,
                            Name_File, Option_Semilogy)

    Name_File = 'Three_Compared_Methods_Log'
    Option_Semilogy = 1
    Plot_Convergence_Curves(Iterations, convergence_curve1, convergence_curve2, convergence_curve3, Name_Result_Folder,
                            Name_File, Option_Semilogy)

"""
    print("Results GWO")
    Exploitation_Resultat_Optimisation(x_Method1)

    print("Results GWO_Discrete")
    Exploitation_Resultat_Optimisation(x_Method2)

    print("Results GWO_continuous_ternary_binary")
    Exploitation_Resultat_Optimisation(x_Method3)

"""
    # Display_xresult_asimage(x_Method3.Optimal_Parameters,Name_Result_Folder)
