import random
import time
from fractions import Fraction

import numpy
import matplotlib.pyplot as plt
from All_Progs.map_library import *

from All_Progs.Optimizers.Continuous_GWO.Functions_GWO import solution
from All_Progs.Optimizers.Continuous_GWO.utils_GWO import *

from All_Progs.Optimizers.Ternary_GWO.Functions_Ternary_GWO import *
from All_Progs.Optimizers.Ternary_GWO.Functions_Chaotic_Ternary_GWO import *
from All_Progs.Optimizers.Ternary_GWO.utils_Ternary import *

from All_Progs.Optimizers.Binary_GWO.Functions_Binary_GWO import *
from All_Progs.Optimizers.Binary_GWO.Functions_Chaotic_Binary_GWO import *
from All_Progs.Optimizers.Binary_GWO.utils_Binary import *

from All_Progs.Optimizers.Mixed_GWO.utils_Mixed_GWO import *


def GWO_continuous_ternary_binary(objf, lb, ub, dim, SearchAgents_no, Max_iter, Nb_Continuous_Unknowns,
                                  Nb_Ternary_Unknowns):
    OptionMap = 'Sigmoid'
    OptionBinary = 0

    # valeurs_a = numpy.zeros(Max_iter)
    # n1 = numpy.zeros(Max_iter)
    # n2 = numpy.zeros(Max_iter)
    # n3 = numpy.zeros(Max_iter)
    # n4 = numpy.zeros(Max_iter)

    # n6=numpy.zeros(Max_iter)
    # n7=numpy.zeros(Max_iter)
    # initialize alpha, beta, and delta_pos
    Alpha_pos = numpy.zeros(dim)
    Alpha_score = float("inf")

    Beta_pos = numpy.zeros(dim)
    Beta_score = float("inf")

    Delta_pos = numpy.zeros(dim)
    Delta_score = float("inf")

    if not isinstance(lb, list):
        lb = [lb] * dim  # borne lower
    if not isinstance(ub, list):
        ub = [ub] * dim  # upper borne

    # Initialize the positions of search agents
    Positions = numpy.zeros((SearchAgents_no, dim))
    for i in range(dim):
        # Positions[:, i] = numpy.random.uniform(lb[i], ub[i], SearchAgents_no)
        # Positions[:, i] = numpy.random.uniform(ub[i], ub[i], SearchAgents_no)  # initialiser  la borne haute.
        Positions[:, i] = numpy.random.uniform(lb[i], ub[i], SearchAgents_no)  # initialiser  la borne haute.

    # Positions=np.floor(Positions)# !! attention ici

    Convergence_curve = numpy.zeros(Max_iter)
    s = solution()
    timerStart = time.time()
    s.startTime = time.strftime("%Y-%m-%d-%H-%M-%S")
    # Main loop
    # r = 2.8
    chaos_sequences = {i: logistic_map(Max_iter) for i in range(SearchAgents_no)}
    last_value = chaos_sequences[0][-1]
    for k, v in chaos_sequences.items():
        v = [i / last_value * 0.5 for i in v]
        # plt.plot(v)
        # print(v)
    # plt.show()

    # Nb_Continuous_Chosen = 0
    # Nb_Binary_or_Ternary_Chosen = 0
    for l in range(Max_iter):
        for i in range(SearchAgents_no):

            # Return back the search agents that go beyond the boundaries of the search space
            for j in range(dim):
                Positions[i, j] = numpy.clip(Positions[i, j], lb[j], ub[j])

            # Calculate objective function for each search agent
            fitness = objf(Positions[i, :])

            # Update Alpha, Beta, and Delta

            if fitness < Alpha_score:
                Alpha_score = fitness  # Update alpha
                Alpha_pos = Positions[i, :].copy()


            elif (fitness > Alpha_score and fitness < Beta_score):

                Beta_score = fitness  # Update beta
                Beta_pos = Positions[i, :].copy()


            elif (fitness > Alpha_score and fitness > Beta_score and fitness < Delta_score):
                Delta_score = fitness  # Update delta
                Delta_pos = Positions[i, :].copy()

        Random1_pos = Positions[random.randint(0, SearchAgents_no - 1), :]
        Random2_pos = Positions[random.randint(0, SearchAgents_no - 1), :]

        # eta = 2
        # c = random.random()

        # a = 2 - 2 * a_2
        # valeurs_a[l] = a

        # Update the Position of search agents including omegas
        for i in range(0, SearchAgents_no):
            # a = 2 * (1 - l * (1 / Max_iter) * (0.5 + chaos_sequences[i][l]))
            # a = 2 * (1 - l * (1 / Max_iter) * (0.5 + 0.5))

            # NEW#############################################

            eta = 2
            # a_2 = (float(Fraction(l, Max_iter - 1))) ** eta

            if l <= (Max_iter - 1) / 2:
                a_2 = (l / ((Max_iter - 1) / 2)) ** eta
            else:
                a_2 = ((l - (Max_iter - 1) / 2) / ((Max_iter - 1) / 2)) ** (1 / eta)

            a = 2 - 2 * a_2 * (0.5 + chaos_sequences[i][l])
            # END NEW#############################################

            for j in range(dim):
                if j < Nb_Continuous_Unknowns:
                    Positions[i, j] = Update_Position_ContinuousGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j],
                                                                    Random1_pos[j],
                                                                    Random2_pos[j], Positions[i, j], a)
                elif (j > Nb_Continuous_Unknowns - 1) & (j < Nb_Continuous_Unknowns + Nb_Ternary_Unknowns):
                    Positions[i, j] = Update_Position_TGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j], Random1_pos[j],
                                                           Random2_pos[j], Positions[i, j], a, OptionMap, OptionBinary)


                elif j > Nb_Continuous_Unknowns + Nb_Ternary_Unknowns - 1:
                    Positions[i, j] = Update_Position_BGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j],
                                                         Random1_pos[j],
                                                         Random2_pos[j], Positions[i, j], a)

        Convergence_curve[l] = Alpha_score

        # n1[l] = Alpha_pos[0]
        # n2[l] = Alpha_pos[1]
        # n3[l] = Alpha_pos[2]
        # n4[l] = Alpha_pos[3]

        Display_Iter(l, Alpha_score, Alpha_pos)

    # print([str(Alpha_pos)])
    # print("Nb_Continuous_Chosen", Nb_Continuous_Chosen)
    # print("Nb_Binary_or_Ternary_Chosen", Nb_Binary_or_Ternary_Chosen)

    timerEnd = time.time()
    s.endTime = time.strftime("%Y-%m-%d-%H-%M-%S")
    s.executionTime = timerEnd - timerStart
    s.convergence = Convergence_curve
    s.optimizer = "GWO"
    s.objfname = objf.__name__
    s.objf_ = objf
    # s.n1 = n1  # solution 1
    # s.n2 = n2  # solution 2
    # s.n3 = n3  # solution 3
    # s.n4 = n4  # solution 3
    # s.val_a = valeurs_a
    # s.eta = eta

    s.Optimal_Parameters = Alpha_pos

    return s


def GWO_continuous_ternary_binary_memory(objf, lb, ub, dim, SearchAgents_no, Max_iter, Nb_Continuous_Unknowns,
                                         Nb_Ternary_Unknowns):
    SearchAgents_no = int(np.ceil(SearchAgents_no / 1))
    # divide by 2 the number of agents to compensate the 2-time computation per agent of the objective function
    # Or do not divide and say it works better
    # at the expense of a slightly higher computational load.

    OptionMap = 'Sigmoid'
    OptionBinary = 0

    # valeurs_a = numpy.zeros(Max_iter)
    # n1 = numpy.zeros(Max_iter)
    # n2 = numpy.zeros(Max_iter)
    # n3 = numpy.zeros(Max_iter)
    # n4 = numpy.zeros(Max_iter)

    # n6=numpy.zeros(Max_iter)
    # n7=numpy.zeros(Max_iter)
    # initialize alpha, beta, and delta_pos
    Alpha_pos = numpy.zeros(dim)
    Alpha_score = float("inf")

    Beta_pos = numpy.zeros(dim)
    Beta_score = float("inf")

    Delta_pos = numpy.zeros(dim)
    Delta_score = float("inf")

    if not isinstance(lb, list):
        lb = [lb] * dim  # borne lower
    if not isinstance(ub, list):
        ub = [ub] * dim  # upper borne

    # Initialize the positions of search agents
    Positions = numpy.ones((SearchAgents_no, dim))
    # Position_ContinuousGWO_Only = numpy.ones((SearchAgents_no, dim))
    fitnessMemory = numpy.ones((SearchAgents_no, 1))
    # PositionsMemory = numpy.ones((SearchAgents_no, dim))

    ScoresBest = 100000 * numpy.ones((SearchAgents_no, 1))
    PositionsBest = numpy.ones((SearchAgents_no, dim))

    for j in range(dim):
        # Positions[:, j] = numpy.random.uniform(ub[j], ub[j], SearchAgents_no)  # initialiser  la borne haute.
        Positions[:, j] = numpy.random.uniform(lb[j], ub[j], SearchAgents_no)  # initialiser  la borne haute.

    PositionsMemory = Positions.copy()
    PositionsBest = Positions.copy()

    for i in range(0, SearchAgents_no):
        fitnessMemory[i, 0] = objf(PositionsMemory[i, :])
        ScoresBest[i, 0] = objf(PositionsBest[i, :])

    # Positions=np.floor(Positions)# !! attention ici

    Convergence_curve = numpy.zeros(Max_iter)
    s = solution()
    timerStart = time.time()
    s.startTime = time.strftime("%Y-%m-%d-%H-%M-%S")
    # Main loop
    # r = 2.8
    chaos_sequences = {i: logistic_map(Max_iter) for i in range(SearchAgents_no)}
    last_value = chaos_sequences[0][-1]
    for k, v in chaos_sequences.items():
        v = [i / last_value * 0.5 for i in v]
        # plt.plot(v)
        # print(v)
    # plt.show()

    # Nb_Continuous_Chosen = 0
    # Nb_Binary_or_Ternary_Chosen = 0
    for l in range(Max_iter):
        for i in range(0, SearchAgents_no):

            # Return back the search agents that go beyond the boundaries of the search space
            for j in range(dim):
                Positions[i, j] = numpy.clip(Positions[i, j], lb[j], ub[j])

            # Calculate objective function for each search agent
            fitness = objf(Positions[i, :])
            PositionsMemory[i, :] = Positions[i, :].copy()

            if fitness < ScoresBest[i, 0]:
                ScoresBest[i, 0] = fitness  # Update alpha
                PositionsBest[i, :] = Positions[i, :].copy()

            # Update Alpha, Beta, and Delta

            if fitness < Alpha_score:
                Alpha_score = fitness  # Update alpha
                Alpha_pos = Positions[i, :].copy()

            elif fitness > Alpha_score and fitness < Beta_score:

                Beta_score = fitness  # Update beta
                Beta_pos = Positions[i, :].copy()

            elif fitness > Alpha_score and fitness > Beta_score and fitness < Delta_score:
                Delta_score = fitness  # Update delta
                Delta_pos = Positions[i, :].copy()

        Random1_pos = Positions[random.randint(0, SearchAgents_no - 1), :]
        Random2_pos = Positions[random.randint(0, SearchAgents_no - 1), :]

        # repositionniong of the worst agents
        IndicesValues = np.argsort(fitnessMemory)
        IndexW1 = IndicesValues[SearchAgents_no - 3]
        IndexW2 = IndicesValues[SearchAgents_no - 2]
        IndexW3 = IndicesValues[SearchAgents_no - 1]

        Positions[IndexW1, :] = 1 / 2 * (Alpha_pos + Beta_pos)
        Positions[IndexW2, :] = 1 / 2 * (Alpha_pos + Delta_pos)
        Positions[IndexW3, :] = 1 / 2 * (Beta_pos + Delta_pos)

        # eta = 2
        # c = random.random()

        # a = 2 - 2 * a_2
        # valeurs_a[l] = a

        # Update the Position of search agents including omegas
        for i in range(0, SearchAgents_no):
            # a = 2 * (1 - l * (1 / Max_iter) * (0.5 + chaos_sequences[i][l]))
            # a = 2 * (1 - l * (1 / Max_iter) * (0.5 + 0.5))

            # NEW#############################################

            eta = 2
            # a_2 = (float(Fraction(l, Max_iter - 1))) ** eta

            if l <= (Max_iter - 1) / 2:
                a_2 = (l / ((Max_iter - 1) / 2)) ** eta
            else:
                a_2 = ((l - (Max_iter - 1) / 2) / ((Max_iter - 1) / 2)) ** (1 / eta)

            a = 2 - 2 * a_2 * (0.5 + chaos_sequences[i][l])
            # END NEW#############################################

            for j in range(dim):
                if j < Nb_Continuous_Unknowns:
                    Positions[i, j] = Update_Position_ContinuousGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j],
                                                                    Random1_pos[j],
                                                                    Random2_pos[j], Positions[i, j], a)
                elif (j > Nb_Continuous_Unknowns - 1) & (j < Nb_Continuous_Unknowns + Nb_Ternary_Unknowns):
                    Positionij_Safe = Positions[i, j]
                    Position_TGWO = Update_Position_TGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j], Random1_pos[j],
                                                         Random2_pos[j], Positionij_Safe, a, OptionMap, OptionBinary)
                    Position_ContinuousGWO = Update_Position_ContinuousGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j],
                                                                           Random1_pos[j],
                                                                           Random2_pos[j], Positionij_Safe, a)
                    Random_Number = random.random()
                    if Random_Number <= a / 2:
                        Positions[i, j] = Position_TGWO
                        # Nb_Binary_or_Ternary_Chosen = Nb_Binary_or_Ternary_Chosen + 1
                        # print("Ternary_Chosen")

                    else:
                        Positions[i, j] = Position_ContinuousGWO
                        # Nb_Continuous_Chosen = Nb_Continuous_Chosen + 1
                        # print("Continuous_Chosen")

                elif j > Nb_Continuous_Unknowns + Nb_Ternary_Unknowns - 1:
                    # Positions[i, j] = Update_Position_BGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j],
                    #                                       Positions[i, j], a)

                    Positionij_Safe = Positions[i, j]
                    Position_BGWO = Update_Position_BGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j],
                                                         Random1_pos[j],
                                                         Random2_pos[j], Positionij_Safe, a)
                    Position_ContinuousGWO = Update_Position_ContinuousGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j],
                                                                           Random1_pos[j],
                                                                           Random2_pos[j], Positionij_Safe, a)
                    # print(Position_ContinuousGWO)
                    # could be tested depending on the application: run Update_Position_ContinuousGWO
                    # for the last half of the iterations.
                    # possibility to Choose between Position_BGWO and Position_ContinuousGWO,
                    # the probability to choose Position_ContinuousGWO being increased for teh last iterations
                    Random_Number = random.random()
                    if Random_Number <= a / 2:
                        Positions[i, j] = Position_BGWO
                        # Nb_Binary_or_Ternary_Chosen = Nb_Binary_or_Ternary_Chosen + 1
                        # print("Binary_Chosen")

                    else:
                        Positions[i, j] = Position_ContinuousGWO  # !!!!!!!!!!
                        # Nb_Continuous_Chosen = Nb_Continuous_Chosen + 1
                        # print("Continuous_Chosen")

            # for j in range(dim):
            #    Position_ContinuousGWO_Only[i, j] = Update_Position_ContinuousGWO(Alpha_pos[j], Beta_pos[j],
            #                                                                      Delta_pos[j],
            #                                                                      Random1_pos[j],
            #                                                                      Random2_pos[j], Positions[i, j], a)

            # if l/5 == np.floor(l / 5):#do this one out of 5 iterations and keep the same number of agents
            # Score_PositionsiInit = fitness
            # Memory effect: if the previous result was better, keep the previous result.

            # Random_Number = random.random()
            # if Random_Number <= a / 2:
            #    Positions[i, :] = PositionsBest[i, :].copy()

            # !!!!! Memory !!!!
            Score_MixedGWOi = objf(Positions[i, :])
            if Score_MixedGWOi > fitnessMemory[i, 0]:
                Positions[i, :] = PositionsMemory[i, :].copy()

        # Positions = PositionsMemory.copy()

        Convergence_curve[l] = Alpha_score

        # n1[l] = Alpha_pos[0]
        # n2[l] = Alpha_pos[1]
        # n3[l] = Alpha_pos[2]
        # n4[l] = Alpha_pos[3]

        Display_Iter(l, Alpha_score, Alpha_pos)

    # print([str(Alpha_pos)])
    # print("Nb_Continuous_Chosen", Nb_Continuous_Chosen)
    # print("Nb_Binary_or_Ternary_Chosen", Nb_Binary_or_Ternary_Chosen)

    timerEnd = time.time()
    s.endTime = time.strftime("%Y-%m-%d-%H-%M-%S")
    s.executionTime = timerEnd - timerStart
    s.convergence = Convergence_curve
    s.optimizer = "GWO"
    s.objfname = objf.__name__
    s.objf_ = objf
    # s.n1 = n1  # solution 1
    # s.n2 = n2  # solution 2
    # s.n3 = n3  # solution 3
    # s.n4 = n4  # solution 3
    # s.val_a = valeurs_a
    # s.eta = eta

    s.Optimal_Parameters = Alpha_pos

    return s


def GWO_continuous_ternary_binary_memory_hybrid(objf, lb, ub, dim, SearchAgents_no, Max_iter, Nb_Continuous_Unknowns,
                                                Nb_Ternary_Unknowns):
    SearchAgents_no = int(np.ceil(SearchAgents_no / 1))
    # divide by 2 the number of agents to compensate the 2-time computation per agent of the objective function
    # Or do not divide and say it works better
    # at the expense of a slightly higher computational load.

    OptionMap = 'Sigmoid'
    OptionBinary = 0

    # valeurs_a = numpy.zeros(Max_iter)
    # n1 = numpy.zeros(Max_iter)
    # n2 = numpy.zeros(Max_iter)
    # n3 = numpy.zeros(Max_iter)
    # n4 = numpy.zeros(Max_iter)

    # n6=numpy.zeros(Max_iter)
    # n7=numpy.zeros(Max_iter)
    # initialize alpha, beta, and delta_pos
    Alpha_pos = numpy.zeros(dim)
    Alpha_score = float("inf")

    Beta_pos = numpy.zeros(dim)
    Beta_score = float("inf")

    Delta_pos = numpy.zeros(dim)
    Delta_score = float("inf")

    if not isinstance(lb, list):
        lb = [lb] * dim  # borne lower
    if not isinstance(ub, list):
        ub = [ub] * dim  # upper borne

    # Initialize the positions of search agents
    Positions = numpy.ones((SearchAgents_no, dim))
    Position_ContinuousGWO_Only = numpy.ones((SearchAgents_no, dim))
    fitnessMemory = numpy.ones((SearchAgents_no, 1))
    # PositionsMemory = numpy.ones((SearchAgents_no, dim))

    ScoresBest = 100000 * numpy.ones((SearchAgents_no, 1))
    PositionsBest = numpy.ones((SearchAgents_no, dim))

    for j in range(dim):
        # Positions[:, j] = numpy.random.uniform(ub[j], ub[j], SearchAgents_no)  # initialiser  la borne haute.
        Positions[:, j] = numpy.random.uniform(lb[j], ub[j], SearchAgents_no)  # initialiser  la borne haute.

    PositionsMemory = Positions.copy()
    PositionsBest = Positions.copy()

    for i in range(0, SearchAgents_no):
        fitnessMemory[i, 0] = objf(PositionsMemory[i, :])
        ScoresBest[i, 0] = objf(PositionsBest[i, :])

    # Positions=np.floor(Positions)# !! attention ici

    Convergence_curve = numpy.zeros(Max_iter)
    s = solution()
    timerStart = time.time()
    s.startTime = time.strftime("%Y-%m-%d-%H-%M-%S")
    # Main loop
    # r = 2.8
    chaos_sequences = {i: logistic_map(Max_iter) for i in range(SearchAgents_no)}
    last_value = chaos_sequences[0][-1]
    for k, v in chaos_sequences.items():
        v = [i / last_value * 0.5 for i in v]
        # plt.plot(v)
        # print(v)
    # plt.show()

    # Nb_Continuous_Chosen = 0
    # Nb_Binary_or_Ternary_Chosen = 0
    for l in range(Max_iter):
        for i in range(0, SearchAgents_no):

            # Return back the search agents that go beyond the boundaries of the search space
            for j in range(dim):
                Positions[i, j] = numpy.clip(Positions[i, j], lb[j], ub[j])

            # Calculate objective function for each search agent
            fitness = objf(Positions[i, :])
            PositionsMemory[i, :] = Positions[i, :].copy()

            if fitness < ScoresBest[i, 0]:
                ScoresBest[i, 0] = fitness  # Update alpha
                PositionsBest[i, :] = Positions[i, :].copy()

            # Update Alpha, Beta, and Delta

            if fitness < Alpha_score:
                Alpha_score = fitness  # Update alpha
                Alpha_pos = Positions[i, :].copy()

            elif fitness > Alpha_score and fitness < Beta_score:

                Beta_score = fitness  # Update beta
                Beta_pos = Positions[i, :].copy()

            elif fitness > Alpha_score and fitness > Beta_score and fitness < Delta_score:
                Delta_score = fitness  # Update delta
                Delta_pos = Positions[i, :].copy()

        Random1_pos = Positions[random.randint(0, SearchAgents_no - 1), :]
        Random2_pos = Positions[random.randint(0, SearchAgents_no - 1), :]

        # repositionniong of the worst agents
        IndicesValues = np.argsort(fitnessMemory)
        IndexW1 = IndicesValues[SearchAgents_no - 3]
        IndexW2 = IndicesValues[SearchAgents_no - 2]
        IndexW3 = IndicesValues[SearchAgents_no - 1]

        Positions[IndexW1, :] = 1 / 2 * (Alpha_pos + Beta_pos)
        Positions[IndexW2, :] = 1 / 2 * (Alpha_pos + Delta_pos)
        Positions[IndexW3, :] = 1 / 2 * (Beta_pos + Delta_pos)

        # eta = 2
        # c = random.random()

        # a = 2 - 2 * a_2
        # valeurs_a[l] = a

        # Update the Position of search agents including omegas
        for i in range(0, SearchAgents_no):
            # a = 2 * (1 - l * (1 / Max_iter) * (0.5 + chaos_sequences[i][l]))
            # a = 2 * (1 - l * (1 / Max_iter) * (0.5 + 0.5))

            # NEW#############################################

            eta = 2
            # a_2 = (float(Fraction(l, Max_iter - 1))) ** eta

            if l <= (Max_iter - 1) / 2:
                a_2 = (l / ((Max_iter - 1) / 2)) ** eta
            else:
                a_2 = ((l - (Max_iter - 1) / 2) / ((Max_iter - 1) / 2)) ** (1 / eta)

            a = 2 - 2 * a_2 * (0.5 + chaos_sequences[i][l])
            # END NEW#############################################
            #a = 2 - 2 * a_2 * (0.5 + 0.5)

            for j in range(dim):
                if j < Nb_Continuous_Unknowns:
                    Positions[i, j] = Update_Position_ContinuousGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j],
                                                                    Random1_pos[j],
                                                                    Random2_pos[j], Positions[i, j], a)
                elif (j > Nb_Continuous_Unknowns - 1) & (j < Nb_Continuous_Unknowns + Nb_Ternary_Unknowns):
                    Positionij_Safe = Positions[i, j]
                    Position_TGWO = Update_Position_TGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j], Random1_pos[j],
                                                         Random2_pos[j], Positionij_Safe, a, OptionMap, OptionBinary)
                    Position_ContinuousGWO = Update_Position_ContinuousGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j],
                                                                           Random1_pos[j],
                                                                           Random2_pos[j], Positionij_Safe, a)
                    Random_Number = random.random()
                    if Random_Number <= a / 2:
                        Positions[i, j] = Position_TGWO
                        # Nb_Binary_or_Ternary_Chosen = Nb_Binary_or_Ternary_Chosen + 1
                        # print("Ternary_Chosen")

                    else:
                        Positions[i, j] = Position_ContinuousGWO
                        # Nb_Continuous_Chosen = Nb_Continuous_Chosen + 1
                        # print("Continuous_Chosen")

                elif j > Nb_Continuous_Unknowns + Nb_Ternary_Unknowns - 1:
                    # Positions[i, j] = Update_Position_BGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j],
                    #                                       Positions[i, j], a)

                    Positionij_Safe = Positions[i, j]
                    Position_BGWO = Update_Position_BGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j],
                                                         Random1_pos[j],
                                                         Random2_pos[j], Positionij_Safe, a)

                    Position_ContinuousGWO = Update_Position_ContinuousGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j],
                                                                           Random1_pos[j],
                                                                           Random2_pos[j], Positionij_Safe, a)
                    # print(Position_ContinuousGWO)
                    # could be tested depending on the application: run Update_Position_ContinuousGWO
                    # for the last half of the iterations.
                    # possibility to Choose between Position_BGWO and Position_ContinuousGWO,
                    # the probability to choose Position_ContinuousGWO being increased for teh last iterations

                    Positions[i, j] = Position_BGWO

                    #Random_Number = random.random()
                    #if Random_Number <= a / 2:
                    #    Positions[i, j] = Position_BGWO
                    #    # Nb_Binary_or_Ternary_Chosen = Nb_Binary_or_Ternary_Chosen + 1
                    #    # print("Binary_Chosen")
                    #else:
                    #    Positions[i, j] = Position_ContinuousGWO  # !!!!!!!!!!
                    #    # Nb_Continuous_Chosen = Nb_Continuous_Chosen + 1
                    #    # print("Continuous_Chosen")

            for j in range(dim):
                Position_ContinuousGWO_Only[i, j] = Update_Position_ContinuousGWO(Alpha_pos[j], Beta_pos[j],
                                                                                  Delta_pos[j],
                                                                                  Random1_pos[j],
                                                                                  Random2_pos[j], Positions[i, j], a)

            # if l/5 == np.floor(l / 5):#do this one out of 5 iterations and keep the same number of agents
            # Score_PositionsiInit = fitness
            # Memory effect: if the previous result was better, keep the previous result.

            # Random_Number = random.random()
            # if Random_Number <= a / 2:
            #    Positions[i, :] = PositionsBest[i, :].copy()

            # !!!!! Memory !!!!
            Score_MixedGWOi = objf(Positions[i, :])
            Score_Position_ContinuousGWO_Onlyi = objf(Position_ContinuousGWO_Only[i, :])

            Index_Min = np.argmin([Score_MixedGWOi, fitnessMemory[i, 0], Score_Position_ContinuousGWO_Onlyi])
            if Index_Min == 1:
                Positions[i, :] = PositionsMemory[i, :].copy()
            elif Index_Min == 2:
                Positions[i, :] = Position_ContinuousGWO_Only[i, :].copy()

            # if Score_MixedGWOi > fitnessMemory[i, 0]:
            #    Positions[i, :] = PositionsMemory[i, :].copy()
            # if Score_MixedGWOi > Score_Position_ContinuousGWO_Onlyi:
            #    Positions[i, :] = Position_ContinuousGWO_Only[i, :].copy()

        # Positions = PositionsMemory.copy()

        Convergence_curve[l] = Alpha_score

        # n1[l] = Alpha_pos[0]
        # n2[l] = Alpha_pos[1]
        # n3[l] = Alpha_pos[2]
        # n4[l] = Alpha_pos[3]

        Display_Iter(l, Alpha_score, Alpha_pos)

    # print([str(Alpha_pos)])
    # print("Nb_Continuous_Chosen", Nb_Continuous_Chosen)
    # print("Nb_Binary_or_Ternary_Chosen", Nb_Binary_or_Ternary_Chosen)

    timerEnd = time.time()
    s.endTime = time.strftime("%Y-%m-%d-%H-%M-%S")
    s.executionTime = timerEnd - timerStart
    s.convergence = Convergence_curve
    s.optimizer = "GWO"
    s.objfname = objf.__name__
    s.objf_ = objf
    # s.n1 = n1  # solution 1
    # s.n2 = n2  # solution 2
    # s.n3 = n3  # solution 3
    # s.n4 = n4  # solution 3
    # s.val_a = valeurs_a
    # s.eta = eta

    s.Optimal_Parameters = Alpha_pos

    return s


def GWO_continuous_binary_Original(objf, lb, ub, dim, SearchAgents_no, Max_iter, Nb_Continuous_Unknowns,
                                   Nb_Ternary_Unknowns):
    OptionMap = 'Sigmoid'
    OptionBinary = 0

    # valeurs_a = numpy.zeros(Max_iter)
    # n1 = numpy.zeros(Max_iter)
    # n2 = numpy.zeros(Max_iter)
    # n3 = numpy.zeros(Max_iter)
    # n4 = numpy.zeros(Max_iter)

    # n6=numpy.zeros(Max_iter)
    # n7=numpy.zeros(Max_iter)
    # initialize alpha, beta, and delta_pos
    Alpha_pos = numpy.zeros(dim)
    Alpha_score = float("inf")

    Beta_pos = numpy.zeros(dim)
    Beta_score = float("inf")

    Delta_pos = numpy.zeros(dim)
    Delta_score = float("inf")

    if not isinstance(lb, list):
        lb = [lb] * dim  # borne lower
    if not isinstance(ub, list):
        ub = [ub] * dim  # upper borne

    # Initialize the positions of search agents
    Positions = numpy.zeros((SearchAgents_no, dim))
    for i in range(dim):
        Positions[:, i] = numpy.random.uniform(lb[i], ub[i], SearchAgents_no)

    # Positions=np.floor(Positions)# !! attention ici

    Convergence_curve = numpy.zeros(Max_iter)
    s = solution()
    timerStart = time.time()
    s.startTime = time.strftime("%Y-%m-%d-%H-%M-%S")
    # Main loop
    # r = 2.8
    chaos_sequences = {i: logistic_map(Max_iter) for i in range(SearchAgents_no)}
    last_value = chaos_sequences[0][-1]
    for k, v in chaos_sequences.items():
        v = [i / last_value * 0.5 for i in v]
        # plt.plot(v)
        # print(v)
    # plt.show()
    for l in range(Max_iter):
        for i in range(SearchAgents_no):

            # Return back the search agents that go beyond the boundaries of the search space
            for j in range(dim):
                Positions[i, j] = numpy.clip(Positions[i, j], lb[j], ub[j])

            # Calculate objective function for each search agent
            fitness = objf(Positions[i, :])

            # Update Alpha, Beta, and Delta

            if fitness < Alpha_score:
                Alpha_score = fitness  # Update alpha
                Alpha_pos = Positions[i, :].copy()


            elif (fitness > Alpha_score and fitness < Beta_score):

                Beta_score = fitness  # Update beta
                Beta_pos = Positions[i, :].copy()


            elif (fitness > Alpha_score and fitness > Beta_score and fitness < Delta_score):
                Delta_score = fitness  # Update delta
                Delta_pos = Positions[i, :].copy()

        Random1_pos = Positions[random.randint(0, SearchAgents_no - 1), :]
        Random2_pos = Positions[random.randint(0, SearchAgents_no - 1), :]

        # eta = 2
        # c = random.random()

        # a = 2 - 2 * a_2
        # valeurs_a[l] = a

        # Update the Position of search agents including omegas
        for i in range(0, SearchAgents_no):
            a = 2 * (1 - l * (1 / Max_iter) * (0.5 + 0.5))

            for j in range(dim):
                if j < Nb_Continuous_Unknowns:
                    Positions[i, j] = Update_Position_ContinuousGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j],
                                                                    Random1_pos[j],
                                                                    Random2_pos[j], Positions[i, j], a)
                elif (j > Nb_Continuous_Unknowns - 1) & (j < Nb_Continuous_Unknowns + Nb_Ternary_Unknowns):
                    Positions[i, j] = Update_Position_TGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j], Random1_pos[j],
                                                           Random2_pos[j], Positions[i, j], a, OptionMap, OptionBinary)

                elif j > Nb_Continuous_Unknowns + Nb_Ternary_Unknowns - 1:
                    Positions[i, j] = Update_Position_BGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j],
                                                           Positions[i, j], a)
                    # Positions[i, j] = Update_Position_ContinuousGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j],
                    #                                                Random1_pos[j],
                    #          Random2_pos[j], Positions[i, j], a)

        Convergence_curve[l] = Alpha_score

        # n1[l] = Alpha_pos[0]
        # n2[l] = Alpha_pos[1]
        # n3[l] = Alpha_pos[2]
        # n4[l] = Alpha_pos[3]

        # if (l % 1 == 0 or Alpha_score == 0):
        # print(['At iteration ' + str(l) + ' the best fitness is ' '' + str(Alpha_score), '[x1, x2, x3]',
        #      str(Alpha_pos[0]), str(Alpha_pos[1]), str(Alpha_pos[2])])

    # print([str(Alpha_pos)])
    timerEnd = time.time()
    s.endTime = time.strftime("%Y-%m-%d-%H-%M-%S")
    s.executionTime = timerEnd - timerStart
    s.convergence = Convergence_curve
    s.optimizer = "GWO"
    s.objfname = objf.__name__
    s.objf_ = objf
    # s.n1 = n1  # solution 1
    # s.n2 = n2  # solution 2
    # s.n3 = n3  # solution 3
    # s.n4 = n4  # solution 3
    # s.val_a = valeurs_a
    # s.eta = eta

    s.Optimal_Parameters = Alpha_pos

    return s
