# !/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Mar 11 09:03:08 2021

@author: marot
"""

import random
import numpy
import math
import time
from fractions import Fraction
from All_Progs.Optimizers.Continuous_GWO.utils_GWO import *
from All_Progs.Optimizers.Mixed_GWO.utils_Mixed_GWO import *

import pickle as serializer
from All_Progs.Optimizers.Continuous_GWO import *


### code pris de S.M 
class solution:
    def __init__(self):
        self.best = 0
        self.bestIndividual = []
        self.convergence = []
        self.optimizer = ""
        self.objfname = ""
        self.startTime = 0
        self.endTime = 0
        self.executionTime = 0
        self.lb = 0
        self.ub = 0
        self.dim = 0
        self.popnum = 0
        self.maxiers = 0
        self.Optimal_Parameters = []


def GWO(objf, lb, ub, dim, SearchAgents_no, Max_iter):

    #n1 = numpy.zeros(Max_iter)
    #n2 = numpy.zeros(Max_iter)
    #n3 = numpy.zeros(Max_iter)
    # n6=numpy.zeros(Max_iter)
    # n7=numpy.zeros(Max_iter)
    # initialize alpha, beta, and delta_pos
    Alpha_pos = numpy.zeros(dim)
    Alpha_score = float("inf")

    Beta_pos = numpy.zeros(dim)
    Beta_score = float("inf")

    Delta_pos = numpy.zeros(dim)
    Delta_score = float("inf")

    if not isinstance(lb, list):
        lb = [lb] * dim
    if not isinstance(ub, list):
        ub = [ub] * dim

    # Initialize the positions of search agents
    Positions = numpy.zeros((SearchAgents_no, dim))
    for i in range(dim):
        #Positions[:, i] = numpy.random.uniform(0, 1, SearchAgents_no) * (ub[i] - lb[i]) + lb[i]
        #Positions[:, i] = numpy.random.uniform(ub[i], ub[i], SearchAgents_no)#initialiser  la borne haute.
        Positions[:, i] = numpy.random.uniform(lb[i], ub[i], SearchAgents_no)#initialiser  la borne haute.

    Convergence_curve = numpy.zeros(Max_iter)
    s = solution()
    timerStart = time.time()
    s.startTime = time.strftime("%Y-%m-%d-%H-%M-%S")
    # Main loop

    for l in range(Max_iter):
        for i in range(SearchAgents_no):

            # Return back the search agents that go beyond the boundaries of the search space
            for j in range(dim):
                Positions[i, j] = numpy.clip(Positions[i, j], lb[j], ub[j])

            # Calculate objective function for each search agent
            fitness = objf(Positions[i, :])

            # Update Alpha, Beta, and Delta
            if fitness < Alpha_score:
                Alpha_score = fitness  # Update alpha
                Alpha_pos = Positions[i, :].copy()


            elif (fitness > Alpha_score and fitness < Beta_score):

                Beta_score = fitness  # Update beta
                Beta_pos = Positions[i, :].copy()


            elif (fitness > Alpha_score and fitness > Beta_score and fitness < Delta_score):
                Delta_score = fitness  # Update delta
                Delta_pos = Positions[i, :].copy()

        a_2 = (float(Fraction(l, (Max_iter - 1))))
        a = 2 - 2 * a_2

        # Update the Position of search agents including omegas
        for i in range(0, SearchAgents_no):
            for j in range(0, dim):
                r1 = random.random()  # r1 is a random number in [0,1]
                r2 = random.random()  # r2 is a random number in [0,1]

                A1 = 2 * a * r1 - a  # Equation (3.3)
                C1 = 2 * r2  # Equation (3.4)

                D_alpha = abs(C1 * Alpha_pos[j] - Positions[i, j])  # Equation (3.5)-part 1
                X1 = Alpha_pos[j] - A1 * D_alpha  # Equation (3.6)-part 1

                r1 = random.random()
                r2 = random.random()

                A2 = 2 * a * r1 - a  # Equation (3.3)
                C2 = 2 * r2  # Equation (3.4)

                D_beta = abs(C2 * Beta_pos[j] - Positions[i, j])  # Equation (3.5)-part 2
                X2 = Beta_pos[j] - A2 * D_beta  # Equation (3.6)-part 2

                r1 = random.random()
                r2 = random.random()

                A3 = 2 * a * r1 - a  # Equation (3.3)
                C3 = 2 * r2  # Equation (3.4)

                D_delta = abs(C3 * Delta_pos[j] - Positions[i, j])  # Equation (3.5)-part 3
                X3 = Delta_pos[j] - A3 * D_delta  # Equation (3.5)-part 3

                Positions[i, j] =  (X1 + X2 + X3) / 3  # Equation (3.7)

        Convergence_curve[l] = Alpha_score
        #n1[l] = Alpha_pos[0]
        #n2[l] = Alpha_pos[1]
        #n3[l] = Alpha_pos[2]

        Display_Iter(l, Alpha_score, Alpha_pos)

        # if (l % 1 == 0 or Alpha_score == 0):
        # print(['At iteration ' + str(l) + ' the best fitness is ' '' + str(Alpha_score), '[x1, x2, x3]',
        #      str(Alpha_pos[0]), str(Alpha_pos[1]), str(Alpha_pos[2])])

    # print([str(Alpha_pos)])
    timerEnd = time.time()
    s.endTime = time.strftime("%Y-%m-%d-%H-%M-%S")
    s.executionTime = timerEnd - timerStart
    s.convergence = Convergence_curve
    s.optimizer = "GWO"
    s.objfname = objf.__name__
    s.objf_ = objf

    s.Optimal_Parameters = Alpha_pos
    #s.n1 = n1  # solution 1
    #s.n2 = n2  # solution 2
    #s.n3 = n3  # solution 3
    return s


def GWO_continu_ameliore(objf, lb, ub, dim, SearchAgents_no, Max_iter):
    valeurs_a = numpy.zeros(Max_iter)
    n1 = numpy.zeros(Max_iter)
    n2 = numpy.zeros(Max_iter)
    n3 = numpy.zeros(Max_iter)
    # n6=numpy.zeros(Max_iter)
    # n7=numpy.zeros(Max_iter)
    # initialize alpha, beta, and delta_pos
    Alpha_pos = numpy.zeros(dim)
    Alpha_score = float("inf")

    Beta_pos = numpy.zeros(dim)
    Beta_score = float("inf")

    Delta_pos = numpy.zeros(dim)
    Delta_score = float("inf")

    if not isinstance(lb, list):
        lb = [lb] * dim  # borne lower
    if not isinstance(ub, list):
        ub = [ub] * dim  # upper borne

    # Initialize the positions of search agents
    Positions = numpy.zeros((SearchAgents_no, dim))
    for i in range(dim):
        Positions[:, i] = numpy.random.uniform(lb[i], ub[i], SearchAgents_no)

    Convergence_curve = numpy.zeros(Max_iter)
    s = solution()
    timerStart = time.time()
    s.startTime = time.strftime("%Y-%m-%d-%H-%M-%S")
    # Main loop

    for l in range(Max_iter):
        for i in range(SearchAgents_no):

            # Return back the search agents that go beyond the boundaries of the search space
            for j in range(dim):
                Positions[i, j] = numpy.clip(Positions[i, j], lb[j], ub[j])

            # Calculate objective function for each search agent
            fitness = objf(Positions[i, :])

            # Update Alpha, Beta, and Del

            if fitness < Alpha_score:
                Alpha_score = fitness  # Update alpha
                Alpha_pos = Positions[i, :].copy()


            elif (fitness > Alpha_score and fitness < Beta_score):

                Beta_score = fitness  # Update beta
                Beta_pos = Positions[i, :].copy()


            elif (fitness > Alpha_score and fitness > Beta_score and fitness < Delta_score):
                Delta_score = fitness  # Update delta
                Delta_pos = Positions[i, :].copy()

        eta = 2
        a_2 = (float(Fraction(l, Max_iter - 1))) ** eta

        if l <= (Max_iter - 1) / 2:
            a_2 = (l / ((Max_iter - 1) / 2)) ** eta
        else:
            a_2 = ((l - (Max_iter - 1) / 2) / ((Max_iter - 1) / 2)) ** (1 / eta)

        a = 2 - 2 * a_2
        valeurs_a[l] = a

        Random1_pos = Positions[random.randint(0, SearchAgents_no - 1), :]
        Random2_pos = Positions[random.randint(0, SearchAgents_no - 1), :]

        # Update the Position of search agents including omegas
        for i in range(0, SearchAgents_no):
            for j in range(0, dim):
                Positions[i, j] = Update_Position_ContinuousGWO(Alpha_pos[j], Beta_pos[j], Delta_pos[j],
                                                                Random1_pos[j],
                                                                Random2_pos[j], Positions[i, j], a)

        Convergence_curve[l] = Alpha_score
        n1[l] = Alpha_pos[0]
        n2[l] = Alpha_pos[1]
        n3[l] = Alpha_pos[2]

        # if (l % 1 == 0 or Alpha_score == 0):
        # print(['At iteration ' + str(l) + ' the best fitness is ' '' + str(Alpha_score), '[x1, x2, x3]',
        #      str(Alpha_pos[0]), str(Alpha_pos[1]), str(Alpha_pos[2])])

    # print([str(Alpha_pos)])
    timerEnd = time.time()
    s.endTime = time.strftime("%Y-%m-%d-%H-%M-%S")
    s.executionTime = timerEnd - timerStart
    s.convergence = Convergence_curve
    s.optimizer = "GWO_continu_ameliore"
    s.objfname = objf.__name__
    s.objf_ = objf
    s.n1 = n1  # solution 1
    s.n2 = n2  # solution 2
    s.n3 = n3  # solution 3
    s.val_a = valeurs_a
    s.eta = eta

    s.Optimal_Parameters = Alpha_pos

    return s


def fitness_function(x):
    x1 = x[0]
    x2 = x[1]
    x3 = x[2]

    # results= x1**2+x2**2+x3**2-2*x3
    results = (x1 - 1) ** 2 + (x2 - 1) ** 2 + (x3 - 1) ** 2

    return results
