import random
import time
from fractions import Fraction

import numpy

from All_Progs.Optimizers.Binary_GWO.Functions_Binary_GWO import *


def Gauss_Function(x, Gauss_Shift):
    Gauss_Output = numpy.exp(-((1 / 0.1) ** 2) * ((x - Gauss_Shift) / 1) ** 2)

    return Gauss_Output


def Binary_Frontier(y, a, Gauss_Shift, Slope, Middle_Value, Delta):
    # V = (1 - a / 2) * (Gauss_Function(y, Gauss_Shift))
    V = sigmoid(y, Slope, Middle_Value + Delta)

    return V


# Faire une version 2 (ou dire que celle - ci est une v1)
# qui correspond exactement à l'article.
# Positionsij=1 if r< ... Cf Eq. 25

def Compute_Contribution_Leader(Leader_posj, Positionsij, a):
    r1 = random.random()
    r2 = random.random()

    A1 = 2 * a * r1 - a  # Equation (3.3)
    C1 = 2 * r2  # Equation (3.4)

    D_leader = abs(C1 * Leader_posj - Positionsij)  # Equation (3.5)-part 2
    y = (Leader_posj - A1 * D_leader)

    return y


def Update_Position_BGWO(Alpha_posj, Beta_posj, Delta_posj, Random1_posj, Random2_posj, Positionsij, a):
    # Positionsij = numpy.clip(Positionsij, 0, 1)
    # Valeurs utilisées réellement dans l'article et qui donnent un bon résultat:
    # Slope = 10
    # Middle_Value = 0.99
    # Delta = 0.0 #

    Slope = 30  # 5 or 10 is nice
    Middle_Value = 0.97
    Delta = 0.0  #

    # version non évolutive utilisée dans l'article
    # Slope = 10
    # Middle_Value = 0.5
    ##Delta = 0.20
    # Delta = 0.49 # Marche le mieux avec 0.4, 50 agents 300 + (a / 40)  # from 1 to 0.5

    ##expressions qui sont dans l'article
    Slope = 10*(1 - a / 6)
    Middle_Value=0.97
    Delta = 0.1*a

    # Slope = 30*(1 - a / 3)
    # Middle_Value=0.97# prendre au moins 0.97
    # Delta = 0.1*a

    ##expressions qui rapprochent du GWO continu.
    # Slope = 100*(1 - a / 300)
    # Middle_Value=0.5
    # Delta = 0.0*a

    # Slope = 10
    # Middle_Value = 0.75
    # Delta = 0.0

    XAlpha=Compute_Contribution_Leader(Alpha_posj, Positionsij, a)
    XBeta=Compute_Contribution_Leader(Beta_posj, Positionsij, a)
    XDelta=Compute_Contribution_Leader(Delta_posj, Positionsij, a)
    XRho1=Compute_Contribution_Leader(Random1_posj, Positionsij, a)
    #XRho2=Compute_Contribution_Leader(Random2_posj, Positionsij, a)

    XMean = 1 / 3 * (XAlpha + XBeta + (1-a/2)*XDelta + a/2 * XRho1)
    Binary_Frontier_Value = Binary_Frontier(XMean, a, 1, Slope, Middle_Value, Delta)

    if random.random() <= Binary_Frontier_Value:
        Positionsij = 1
    else:
        Positionsij = 0

    return Positionsij


def Update_Position_BGWO_Cross_Over(Alpha_posj, Beta_posj, Delta_posj, Positionsij, a):
    r1 = random.random()  # r1 is a random number in [0,1]
    r2 = random.random()  # r2 is a random number in [0,1]

    # Positionsij = numpy.clip(Positionsij, 0, 1)
    # Valeurs utilisées réellement dans l'article et qui donnent un bon résultat:
    # Slope = 10
    # Middle_Value = 0.99
    # Delta = 0.0 #

    Slope = 5  # 5 or 10 is nice
    Middle_Value = 0.99
    Delta = 0.0  #

    # version non évolutive utilisée dans l'article
    # Slope = 10
    # Middle_Value = 0.5
    ##Delta = 0.20
    # Delta = 0.49 # Marche le mieux avec 0.4, 50 agents 300 + (a / 40)  # from 1 to 0.5

    ##expressions qui sont dans l'article
    # Slope = 10*(1 - a / 6)
    # Middle_Value=0.98
    # Delta = 0.1*a

    ##expressions qui rapprochent du GWO continu.
    # Slope = 100*(1 - a / 300)
    # Middle_Value=0.5
    # Delta = 0.0*a

    # Slope = 10
    # Middle_Value = 0.75
    # Delta = 0.0

    A1 = 2 * a * r1 - a  # Equation (3.3)
    C1 = 2 * r2  # Equation (3.4)

    """
    Mettre à jour avec Alpha_pos et Positions 
    """

    D_alpha = abs(C1 * Alpha_posj - Positionsij)  # Equation (3.5)-part 1

    AD = -A1 * D_alpha
    V1 = Binary_Frontier(AD, a, 1, Slope, Middle_Value, Delta)

    if V1 < random.random():
        V1 = 0
    else:
        V1 = 1

    X1 = (Alpha_posj + V1) >= 1  # Equation (3.6)-part 1

    r1 = random.random()
    r2 = random.random()

    A2 = 2 * a * r1 - a  # Equation (3.3)
    C2 = 2 * r2  # Equation (3.4)

    """
    Mettre à jour avec Beta_pos et Positions 
    """

    D_beta = abs(C2 * Beta_posj - Positionsij)  # Equation (3.5)-part 2

    AD = -A2 * D_beta
    V2 = Binary_Frontier(AD, a, 1, Slope, Middle_Value, Delta)

    if V2 < random.random():
        V2 = 0
    else:
        V2 = 1

    X2 = (Beta_posj + V2) >= 1  # Equation (3.6)-part 2

    r1 = random.random()
    r2 = random.random()

    A3 = 2 * a * r1 - a  # Equation (3.3)
    C3 = 2 * r2  # Equation (3.4)

    """
    Mettre à jour avec Delta_pos et Positions 
    """

    D_delta = abs(C3 * Delta_posj - Positionsij)  # Equation (3.5)-part 3

    AD = -A3 * D_delta
    V3 = Binary_Frontier(AD, a, 1, Slope, Middle_Value, Delta)

    if V3 < random.random():
        V3 = 0
    else:
        V3 = 1

    X3 = (Delta_posj + V3) >= 1

    Positionsij = CrossOver(X1, X2, X3)  # Equation (23)

    return Positionsij
