import random
import time
from fractions import Fraction

import numpy
import matplotlib.pyplot as plt
import All_Progs

from All_Progs.map_library import *


def sigmoid(x, A, C):
    z = 1 / (1 + numpy.exp(-A * (x - C)))

    return z


def CrossOver(X1, X2, X3):
    r = random.random()
    y = 0
    if r < 0.333:
        y = X1
    elif r < 0.6666:
        y = X2
    else:
        y = X3
    return y


def GWO_binary_chaotic(objf, lb, ub, dim, SearchAgents_no, Max_iter):
    valeurs_a = numpy.zeros(Max_iter)
    n1 = numpy.zeros(Max_iter)
    n2 = numpy.zeros(Max_iter)
    n3 = numpy.zeros(Max_iter)
    # n6=numpy.zeros(Max_iter)
    # n7=numpy.zeros(Max_iter)
    # initialize alpha, beta, and delta_pos
    Alpha_pos = numpy.zeros(dim)
    Alpha_score = float("inf")

    Beta_pos = numpy.zeros(dim)
    Beta_score = float("inf")

    Delta_pos = numpy.zeros(dim)
    Delta_score = float("inf")

    if not isinstance(lb, list):
        lb = [lb] * dim  # borne lower
    if not isinstance(ub, list):
        ub = [ub] * dim  # upper borne

    # Initialize the positions of search agents
    Positions = numpy.zeros((SearchAgents_no, dim))
    for i in range(dim):
        """
        #Compléter avec 
        numpy.random.uniform(?,?,?)
        lb
        ub
        """
        Positions[:, i] = numpy.random.uniform(lb[i], ub[i], SearchAgents_no)

    Convergence_curve = numpy.zeros(Max_iter)
    s = solution()
    timerStart = time.time()
    s.startTime = time.strftime("%Y-%m-%d-%H-%M-%S")
    # Main loop
    r = 2.8
    chaos_sequences = {i: logistic_map(Max_iter) for i in range(SearchAgents_no)}
    last_value = chaos_sequences[0][-1]
    for k, v in chaos_sequences.items():
        v = [i / last_value * 0.5 for i in v]
        # plt.plot(v)
        # print(v)
    # plt.show()
    for l in range(Max_iter):
        for i in range(SearchAgents_no):

            # Return back the search agents that go beyond the boundaries of the search space
            for j in range(dim):
                Positions[i, j] = numpy.clip(Positions[i, j], lb[j], ub[j])

            # Calculate objective function for each search agent
            fitness = objf(Positions[i, :])

            # Update Alpha, Beta, and Delta
            """
            #Compléter avec 
            Alpha_score
            Beta_score
            Delta_score
            lb
            ub
            """

            if fitness < Alpha_score:
                Alpha_score = fitness  # Update alpha
                Alpha_pos = Positions[i, :].copy()


            elif (fitness > Alpha_score and fitness < Beta_score):

                Beta_score = fitness  # Update beta
                Beta_pos = Positions[i, :].copy()


            elif (fitness > Alpha_score and fitness > Beta_score and fitness < Delta_score):
                Delta_score = fitness  # Update delta
                Delta_pos = Positions[i, :].copy()

        eta = 2
        c = random.random()

        # a = 2 - 2 * a_2
        # valeurs_a[l] = a

        # Update the Position of search agents including omegas
        for i in range(0, SearchAgents_no):
            a = 2 - l * (2 / Max_iter) * (0.5 + chaos_sequences[i][l])

            for j in range(0, dim):

                r1 = random.random()  # r1 is a random number in [0,1]
                r2 = random.random()  # r2 is a random number in [0,1]

                """
                Mettre à jour avec a, r1, r2
                """

                A1 = 2 * a * r1 - a  # Equation (3.3)
                C1 = 2 * r2  # Equation (3.4)

                """
                Mettre à jour avec Alpha_pos et Positions 
                """

                D_alpha = abs(C1 * Alpha_pos[j] - Positions[i, j])  # Equation (3.5)-part 1

                V1 = sigmoid(-A1 * D_alpha, 10, 0.5)

                if V1 < random.random():
                    V1 = 0
                else:
                    V1 = 1

                X1 = (Alpha_pos[j] + V1) >= 1  # Equation (3.6)-part 1

                r1 = random.random()
                r2 = random.random()

                A2 = 2 * a * r1 - a  # Equation (3.3)
                C2 = 2 * r2  # Equation (3.4)

                """
                Mettre à jour avec Beta_pos et Positions 
                """

                D_beta = abs(C2 * Beta_pos[j] - Positions[i, j])  # Equation (3.5)-part 2

                V2 = sigmoid(-A2 * D_beta, 10, 0.5)

                if V2 < random.random():
                    V2 = 0
                else:
                    V2 = 1

                X2 = (Beta_pos[j] + V2) >= 1  # Equation (3.6)-part 2

                r1 = random.random()
                r2 = random.random()

                A3 = 2 * a * r1 - a  # Equation (3.3)
                C3 = 2 * r2  # Equation (3.4)

                """
                Mettre à jour avec Delta_pos et Positions 
                """

                D_delta = abs(C3 * Delta_pos[j] - Positions[i, j])  # Equation (3.5)-part 3
                V3 = sigmoid(-A3 * D_delta, 10, 0.5)

                if V3 < random.random():
                    V3 = 0
                else:
                    V3 = 1

                X3 = (Delta_pos[j] + V3) >= 1

                Positions[i, j] = CrossOver(X1, X2, X3)  # Equation (23)

        Convergence_curve[l] = Alpha_score
        n1[l] = Alpha_pos[0]
        n2[l] = Alpha_pos[1]
        n3[l] = Alpha_pos[2]

        # if (l % 1 == 0 or Alpha_score == 0):
        # print(['At iteration ' + str(l) + ' the best fitness is ' '' + str(Alpha_score), '[x1, x2, x3]',
        #      str(Alpha_pos[0]), str(Alpha_pos[1]), str(Alpha_pos[2])])

    timerEnd = time.time()
    s.endTime = time.strftime("%Y-%m-%d-%H-%M-%S")
    s.executionTime = timerEnd - timerStart
    s.convergence = Convergence_curve
    s.optimizer = "GWO_continu_ameliore"
    s.objfname = objf.__name__
    s.objf_ = objf
    s.n1 = n1  # solution 1
    s.n2 = n2  # solution 2
    s.n3 = n3  # solution 3
    s.val_a = valeurs_a
    s.eta = eta
    return s
