""" Display_ResultsFile """
import math

import pyforest
import matplotlib.pyplot as plt
from All_Progs.Basic_Commands import *
from All_Progs.Test_Functions.Benchmarks import *

# import matplotlib as plt
pyforest.active_imports()


def Display_Numerical_Results(Estimated_Optimal_Parameters, Optimal_Score_Estimated, Iterations, Execution_Time):
    print("Estimated values:")

    for ind_Parameter in range(0, np.size(Estimated_Optimal_Parameters, 0)):
        print("Parameter index:", ind_Parameter, "Estimated value:",
              Estimated_Optimal_Parameters[ind_Parameter])

    print("Optimal Score estimated:", Optimal_Score_Estimated)
    print("Execution time:", Execution_Time, "s")


def Display_Visual_Results(Estimated_Optimal_Parameters, convergence, Iterations, Execution_Time, Name_Result_Folder,
                           Name_File):
    # plt.plot(convergence)
    # plt.show()
    fig = plt.figure()
    plt.plot(convergence)  # , label='convergence'
    # plt.legend()

    wholeNameFile = Name_Result_Folder + Name_File
    plt.savefig(wholeNameFile + '.eps', format='eps', dpi=1000)
    plt.savefig(wholeNameFile + '.png', format='png', dpi=1000)
    plt.show()
    plt.close(fig)

    # lines = ['Readme', 'How to write text files in Python']
    # with open('readme.txt', 'w') as f:
    #    for line in lines:
    #        f.write(line)
    #        f.write('\n')
    Name_File_txt = 'results' + str(Name_File[-1]) + '.txt'
    wholeNameFile_txt = Name_Result_Folder + Name_File_txt
    with open(wholeNameFile_txt, 'w') as f:
        f.write("Position du meilleur:")
        f.write('\n')

        for ind_Parameter in range(0, np.size(Estimated_Optimal_Parameters, 0)):
            f.write(" %.15f " % (Estimated_Optimal_Parameters[ind_Parameter]))
            f.write('\n')
        f.write('\n')

        f.write("Valeur du meilleur: %.15f " % (convergence[-1]))
        f.write('\n')

        f.write("Temps de calcul: %.15f " % (Execution_Time))
        f.write('\n')

        #    f.write(
        #    "\nFin de calcul...\n\nPosition du meilleur score: %.15f %.15f %.15f %.15f\n\nValeur du meilleur: %.15f\n\nTemps de calcul: %f s" % (
        #        Estimated_Optimal_Parameters[0], Estimated_Optimal_Parameters[1],
        #        Estimated_Optimal_Parameters[2], Estimated_Optimal_Parameters[3], convergence[-1],
        #        Execution_Time))

    # plt.rc('text', usetex=True)
    # plt.rc('legend', frameon=False)  # PS doesn't do well with transparencies

    x_Axis = My_Vector(1, Iterations, 1)
    plt.plot(x_Axis, convergence)

    fig, ax = plt.subplots()
    ax.plot(x_Axis, convergence)  # , label=r'$convergence curve$' # Latex legend label.
    # ax.text(1, 0, r"$e^{ix} = \cos(x) + i\sin(x)$")  # More Latex text.
    # ax.legend(loc="upper left")


def Display_Numerical_and_Visual_Results(x, Name_File, Name_Result_Folder):
    Execution_Time = x.executionTime
    convergence = x.convergence
    Estimated_Optimal_Parameters = x.Optimal_Parameters

    Iterations = np.size(convergence, 0)
    Optimal_Score_Estimated = convergence[Iterations - 1]

    Display_Numerical_Results(Estimated_Optimal_Parameters, Optimal_Score_Estimated, Iterations, Execution_Time)

    Display_Visual_Results(Estimated_Optimal_Parameters, convergence, Iterations, Execution_Time, Name_Result_Folder,
                           Name_File)


def Display_Numerical_Results_Only(x):
    Execution_Time = x.executionTime
    convergence = x.convergence
    Estimated_Optimal_Parameters = x.Optimal_Parameters

    Iterations = np.size(convergence, 0)
    Optimal_Score_Estimated = convergence[Iterations - 1]

    Display_Numerical_Results(Estimated_Optimal_Parameters, Optimal_Score_Estimated, Iterations, Execution_Time)


def Display_xresult_asimage(x, Name_Result_Folder):
    dim = len(x)
    # x=x-[0]*dim
    # x=np.round(x)
    print(['epsilon values', str(x[0]), str(x[1]), str(x[2])])

    ################################################################
    Nb_Epsilon_Values, Interpolation_Factor = Define_Epsilon_and_Interpolation_Values()

    Epsilon_Values = Define_Epsilon_Values(Nb_Epsilon_Values)
    print(['Expected epsilon values', str(Epsilon_Values)])

    Nb_Pixels_Small_Image, Nb_Rows_Small_Image, Nb_Cols_Small_Image, Nb_Pixels, Nb_Rows, Nb_Cols = Define_Nb_Pixels_Rows_Cols(
        dim, Nb_Epsilon_Values, Interpolation_Factor)

    x_epsilon, x_image_Small = Define_Epsilon_And_Image_out_of_x(x, Nb_Epsilon_Values)
    print(['Estimated epsilon values', str(x_epsilon)])

    x_image = Two_Dimensional_Image_Interpolation(x_image_Small,
                                                  Interpolation_Factor)  # A nice function for 2D interpolation should be created.

    # target image that should be retrieved.
    Target_Image = Define_Target_Image(Epsilon_Values, Nb_Rows, Nb_Cols)
    ################################################################

    np.size(Target_Image)

    fig1 = plt.figure(1)
    plt.imshow(x_image_Small, cmap="gray")
    plt.title("Estimated Small")
    wholeNameFile = Name_Result_Folder + 'EstimatedSmall'
    # plt.savefig(wholeNameFile + '.eps', format='eps', dpi=1000)
    plt.savefig(wholeNameFile + '.png', format='png', dpi=1000)
    plt.show()
    plt.close(fig1)

    fig2 = plt.figure(2)
    plt.imshow(x_image, cmap="gray")
    plt.title("Estimated")
    wholeNameFile = Name_Result_Folder + 'Estimated'
    # plt.savefig(wholeNameFile + '.eps', format='eps', dpi=1000)
    plt.savefig(wholeNameFile + '.png', format='png', dpi=1000)
    plt.show()
    plt.close(fig2)


    fig3 = plt.figure(3)
    plt.imshow(Target_Image, cmap="gray")
    plt.title("Expected")
    wholeNameFile = Name_Result_Folder + 'Expected'
    # plt.savefig(wholeNameFile + '.eps', format='eps', dpi=1000)
    plt.savefig(wholeNameFile + '.png', format='png', dpi=1000)
    plt.show()
    plt.close(fig3)

    return
