from scipy.stats import ranksums
import numpy as np

rng = np.random.default_rng()

sample1 = rng.uniform(-1, 1, 200)

sample2 = rng.uniform(-0.5, 1.5, 300) # a shifted distribution

[statistic_out, p_value_out]=ranksums(sample1, sample2)
print("RanksumsResult")
print("statistic: ", statistic_out, "p_value_out: ", p_value_out)
#RanksumsResult(statistic=-7.887059, pvalue=3.09390448e-15)  # may vary

[statistic_out, p_value_out]=ranksums(sample1, sample2, alternative='less')
print("RanksumsResult")
print("statistic: ", statistic_out, "p_value_out: ", p_value_out)
#RanksumsResult(statistic=-7.750585297581713, pvalue=4.573497606342543e-15) # may vary

[statistic_out, p_value_out]=ranksums(sample1, sample2, alternative='greater')
print("RanksumsResult")
print("statistic: ", statistic_out, "p_value_out: ", p_value_out)
##RanksumsResult(statistic=-7.750585297581713, pvalue=0.9999999999999954) # may vary
