# -*- coding: utf-8 -*-
"""SVM_GWO

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1CTlKjrj2LxKwY7ffoLDLyUnlx-uA3ZNo

%%% https://github.com/maumauuu/gwo

"""

#!/usr/bin/env python3
# -*- coding: utf-8 -*-
from pyforest import train_test_split

"""
Created on Mon Dec 14 19:33:25 2020

@author: jmarot
"""
import pyforest
pyforest.active_imports()
from sklearn.svm import SVC

from All_Progs.Test_Functions.Functions_svm import *
from All_Progs.Optimizers.Functions_GWO import *

# The data set
img_path = "SceneData/"

# Lets create 2 set of arrays. One to store the Image data and anther one for label details
X =[] # Stores the  image hog data
label = [] # Stores the  image label


scene_label=['airport', 'highway', 'office',  'street',  'train_station']


### jpeg_to_array function will loades the image from the given path and stores the hog features in to X respectively

def jpeg_to_array (scene_type, img_root_path):
    scene_path = os.path.join(img_root_path,scene_type.lower())
    #print('Loading  data images for scene type '+scene_type)
    
    for img in os.listdir(scene_path):
        img_path = os.path.join(scene_path,img)
        
        if img_path.endswith('.jpg'):
            X.append(hog_data_extractor(img_path))
            label.append(str(scene_type))
            
### Call jpeg_to_array function to load the  images

[jpeg_to_array(scene,img_path)for scene in scene_label]
#print('X length: ', len(X))

###Using Label Encoder to encode the scene labels
le = LabelEncoder()
y = le.fit_transform(label)

### split data in train and test
x_train, x_test, y_train, y_test = train_test_split(X, label, test_size = 0.2)

## data scaling
scaler = MinMaxScaler().fit(x_train)
x_train = scaler.transform(x_train)
x_test = scaler.transform(x_test)

        
def compute_svmacc(x1, x2, kernel_string):
    model = SVC(C= x1, gamma=x2, kernel= kernel_string)
    model.fit(x_train, y_train)
    y_pred= model.predict(x_test)
    return accuracy_score(y_test, y_pred)


def Run_SVM(x):

    x1=x[0]
    x2=x[1]
    x3=round(x[2])

    if x3==1:
      kernel_String='rbf' 
    elif x3==2:
      kernel_String='linear' 

    Accuracy=compute_svmacc(x1, x2, kernel_String)
    FRR=100*(1-Accuracy)


    return FRR
    
def Mon_Critere(x):

    x1=x[0]
    x2=x[1]
    x3=round(x[2])
    Critere=100*abs(1-x1) + 200*abs(2-x2)+ 200*abs(7-x3)


    return Critere


"""
lb =[10**3,10**(-4),1]
ub = [10**3,10**(-2),1]
"""


lb =[1*10**-4,10**(-4),10**(-4)]
ub = [1*10**4,10**(4),10**(4)]


"""
lb =[10**3,10**(-3),1]
ub = [10**3,10**(-3),1]

PopulationSize=6
Iterations=2
"""


# pour lancer la nuit:
PopulationSize=4
Iterations=10


dim=3

"""
Accuracy=compute_svmacc(1000, 0.001, 'rbf')
FRR=100*(1-Accuracy)
print(FRR)
#Donne FRR=1-0.64=36 
#'At iteration 0 the best fitness is 35.238095238095234', '[x1, x2, x3]', '3885.788075431488', '0.00518281757223963', '1.7380211381268398']
# 12 runs 2700 secondes.
"""

print('start GWO')
print("Nb iterations prevu:",Iterations)

#Run_SVM_Surrogate
#Run_SVM
#fitness_function
#Run_SVM
x=GWO_continu_ameliore(Mon_Critere,lb,ub,dim,PopulationSize,Iterations)

fin=x.executionTime
print("le temps d'optimisation",fin,"s")
convergence=x.convergence
x1=x.n1
x2=x.n2
x3=x.n3

print(x1[Iterations-1])
print(x2[Iterations-1])
print(round(x3[Iterations-1]))
Optimal_Score_Estimated=convergence[Iterations-1]
Optimal_Accuracy_Estimated=100-convergence[Iterations-1]

print("Optimal Score estimated:",Optimal_Score_Estimated)
print("Optimal Accuracy estimated:",Optimal_Accuracy_Estimated)



plt.plot(convergence)
plt.show()


with open('Results/results_svm.txt', 'w') as f:
    f.write("\nFin de calcul...\n\nPosition du meilleur score: %.15f %.15f %.15f\n\nValeur du meilleur: %.15f\n\nTemps de calcul: %f s"%(x1[Iterations-1],x2[Iterations-1],x3[Iterations-1],convergence[-1],fin))


"""

Accuracy_GridSearch=compute_svmacc(1000, 0.001, 'rbf')
FRRGridSearch=100*(1-Accuracy_GridSearch)

print("Grid search:")
print("FRR for 1000, 0.001, 'rbf':",FRRGridSearch)
print("Accuracy for 1000, 0.001, 'rbf':",Accuracy_GridSearch)

Accuracy=compute_svmacc(10, 0.0005, 'rbf')
FRR=100*(1-Accuracy)

print("for 10, 0.0005:")
print("FRR:",FRR)
print("Accuracy:",Accuracy)

print("ASIDE Grid search:")
Accuracy=compute_svmacc(100, 0.001, 'rbf')
FRR=100*(1-Accuracy)

"""


"""
['At iteration 1 the best fitness is 29.52380952380952', '[x1, x2, x3]', '1000.0', '0.0003366859208968813', '1.0']
le temps d'optimisation 2789.161326646805 s
"""

"""# Nouvelle section"""
