# -*- coding: utf-8 -*-
"""
Created on Tue May 17 12:46:20 2016

@author: Hossam Faris
"""
import pyforest

import numpy as np
import matplotlib.pyplot as plt
import math
from All_Progs.Basic_Commands import *


# define the function blocks
def prod(it):
    p = 1
    for n in it:
        p *= n
    return p


def Ufun(x, a, k, m):
    y = k * ((x - a) ** m) * (x > a) + k * ((-x - a) ** m) * (x < (-a))
    return y


def Cloak_Surrogate(x):
    # We make 2D interpolation.
    # We produce 'Interpolation_Factor' pixels out of 1 pixel

    dim = len(x)
    Nb_Epsilon_Values, Interpolation_Factor = Define_Epsilon_and_Interpolation_Values()

    Epsilon_Values = Define_Epsilon_Values(Nb_Epsilon_Values)

    Nb_Pixels_Small_Image, Nb_Rows_Small_Image, Nb_Cols_Small_Image, Nb_Pixels, Nb_Rows, Nb_Cols = Define_Nb_Pixels_Rows_Cols(
        dim, Nb_Epsilon_Values, Interpolation_Factor)

    x_epsilon, x_image_Small = Define_Epsilon_And_Image_out_of_x(x, Nb_Epsilon_Values)

    x_image = Two_Dimensional_Image_Interpolation(x_image_Small,
                                                  Interpolation_Factor)  # A nice function for 2D interpolation should be created.
    # x_image = x_image1  # A nice function for 2D interpolation should be created.

    # a_image is the target image that should be retrieved.
    Target_Image = Define_Target_Image(Epsilon_Values, Nb_Rows, Nb_Cols)

    Criterion_image = np.abs(x_image - Target_Image) / (Nb_Rows * Nb_Cols)

    Vector_Criterion_image = np.reshape(Criterion_image, int(Nb_Rows * Nb_Cols))
    o_image = np.power(np.sum(np.power(Vector_Criterion_image, 4)), 1 / 4)

    Vector_Criterion_epsilon = np.abs(x_epsilon - Epsilon_Values) / len(x_epsilon)
    o_epsilon = np.power(np.sum(np.power(Vector_Criterion_epsilon, 4)), 1 / 4)

    # o = np.sum(x ** 2)
    # o = np.tanh(np.sqrt(np.sum(x ** 2)))
    o = o_image

    # o = o_epsilon + o_image

    """
    o = (
            -20 * np.exp(-0.2 * np.sqrt(np.sum(x ** 2) / dim))
            - np.exp(np.sum(np.cos(2 * math.pi * x)) / dim)
            + 20
            + np.exp(1)
    )
    """

    return o


def Define_Epsilon_and_Interpolation_Values():
    Nb_Epsilon_Values = 3
    Interpolation_Factor = 4
    return Nb_Epsilon_Values, Interpolation_Factor


def Define_Epsilon_Values(Nb_Epsilon_Values):
    Epsilon_Values = 0 * np.ones(Nb_Epsilon_Values)  # default
    for Index_Epsilon in My_Vector(1, Nb_Epsilon_Values, 1):
        Epsilon_Values[Index_Epsilon - 1] = 0.22 * Index_Epsilon

    Epsilon_Values[1] = 0.81
    return Epsilon_Values


def Define_Nb_Pixels_Rows_Cols(dim, Nb_Epsilon_Values, Interpolation_Factor):
    Nb_Pixels_Small_Image = (dim - Nb_Epsilon_Values)
    Nb_Rows_Small_Image = np.floor(np.sqrt(Nb_Pixels_Small_Image))  # Nb rows in the large image
    Nb_Cols_Small_Image = Nb_Rows_Small_Image  # Nb cols in the large image

    Nb_Pixels = Nb_Pixels_Small_Image * Interpolation_Factor
    Nb_Rows = np.floor(np.sqrt(Nb_Pixels))  # Nb rows in the large image
    Nb_Cols = Nb_Rows  # Nb cols in the large image

    return Nb_Pixels_Small_Image, Nb_Rows_Small_Image, Nb_Cols_Small_Image, Nb_Pixels, Nb_Rows, Nb_Cols


def Define_Epsilon_And_Image_out_of_x(x, Nb_Epsilon_Values):
    x_epsilon = x[0:Nb_Epsilon_Values]
    Epsilon_Values = x_epsilon

    x_image_grey_level_indices = x[Nb_Epsilon_Values:]
    Nb_Pixels_Small_Image = len(x_image_grey_level_indices)
    Nb_Rows_Small_Image = np.floor(np.sqrt(Nb_Pixels_Small_Image))  # Nb rows in the large image
    Nb_Cols_Small_Image = Nb_Rows_Small_Image  # Nb cols in the large image

    # build the test image out of the grey level indices
    Image_Small_Vector = 0 * np.ones(Nb_Pixels_Small_Image)
    for Index_Pixel in My_Vector(1, Nb_Pixels_Small_Image, 1):
        Grey_Level_Value = Epsilon_Values[int(x_image_grey_level_indices[Index_Pixel - 1])]
        Image_Small_Vector[Index_Pixel - 1] = Grey_Level_Value

    x_Image_Small = np.reshape(Image_Small_Vector, (int(Nb_Rows_Small_Image), int(Nb_Cols_Small_Image)))

    return x_epsilon, x_Image_Small


def Define_Target_Image(Epsilon_Values, Nb_Rows, Nb_Cols):
    Target_Image = np.array([[Epsilon_Values[0], Epsilon_Values[1]], [Epsilon_Values[2], Epsilon_Values[0]]])

    Nbrowscolsinblock = int(Nb_Rows / 2)
    Block0 = Epsilon_Values[0] * np.ones((Nbrowscolsinblock, Nbrowscolsinblock))
    Block1 = Epsilon_Values[1] * np.ones((Nbrowscolsinblock, Nbrowscolsinblock))
    Block2 = Epsilon_Values[2] * np.ones((Nbrowscolsinblock, Nbrowscolsinblock))

    Block01 = np.concatenate((Block0, Block1), axis=0)
    Block20 = np.concatenate((Block2, Block0), axis=0)

    Target_Image = np.concatenate((Block01, Block20), axis=1)

    # Target_Image = np.array([[Block0, Block1], [Block2, Block0]])

    # Target_Image = np.tile(Target_Image, (int(Nb_Rows / 2), int(Nb_Cols / 2)))

    return Target_Image


def Define_a(dim):
    NbSensors = dim - 5
    a = np.zeros(dim)
    a[0] = np.pi  # 3.14159
    a[1] = 1
    a[2] = 1
    a[3] = 0
    a[4] = 0
    a[5] = 0 #1
    # Sensors around the vertical should be ON logically
    #a[5 + int(np.floor(NbSensors / 2) - 2)] = 1
    #a[5 + int(np.floor(NbSensors / 2) - 1)] = 1
    a[5 + int(np.floor(NbSensors / 2))] = 1
    #a[5 + int(np.floor(NbSensors / 2) + 1)] = 1
    #a[5 + int(np.floor(NbSensors / 2) + 2)] = 1

    return a


def Radar_Surrogate(x):
    dim = len(x)
    #x = np.round(x)

    A = F1(x) / len(x)
    B = (np.sqrt(F1(x)) ) / len(x)  #+ sum(a[4:]) / len(x)

    o = np.sqrt((1 + A) * (1 + B)) - 1 + 10 ** (-8)
    return o


def F1(x):
    dim = len(x)
    a = Define_a(dim)

    s = np.sum((x - a) ** 2) #+ 10 ** (-8)
    return s


def F2(x):
    o = sum(abs(x)) + prod(abs(x))
    return o


def F3(x):
    dim = len(x) + 1
    o = 0
    for i in range(1, dim):
        o = o + (np.sum(x[0:i])) ** 2
    return o


def F4(x):
    o = max(abs(x))
    return o


def F5(x):
    dim = len(x)
    o = np.sum(
        100 * (x[1:dim] - (x[0: dim - 1] ** 2)) ** 2 + (x[0: dim - 1] - 1) ** 2
    )
    return o


def F6(x):
    o = np.sum(abs((x + 0.5)) ** 2)
    return o


def F7(x):
    dim = len(x)

    w = [i for i in range(len(x))]
    for i in range(0, dim):
        w[i] = i + 1
    o = np.sum(w * (x ** 4)) + np.random.uniform(0, 1)
    return o


def F8(x):
    o = sum(-x * (np.sin(np.sqrt(abs(x)))))
    return o


def F9(x):
    dim = len(x)
    o = np.sum(x ** 2 - 10 * np.cos(2 * math.pi * x)) + 10 * dim
    return o


def F10(x):
    dim = len(x)
    # x=x-[0]*dim
    # x=np.round(x)
    a = Define_a(dim)
    x = x - a

    o = (
            -20 * np.exp(-0.2 * np.sqrt(np.sum(x ** 2) / dim))
            - np.exp(np.sum(np.cos(2 * math.pi * x)) / dim)
            + 20
            + np.exp(1)
            #+ 10 ** (-8)
    )
    return o


def F11(x):
    dim = len(x)
    w = [i for i in range(len(x))]
    w = [i + 1 for i in w]
    o = np.sum(x ** 2) / 4000 - prod(np.cos(x / np.sqrt(w))) + 1
    return o


def F12(x):
    dim = len(x)
    o = (math.pi / dim) * (
            10 * ((np.sin(math.pi * (1 + (x[0] + 1) / 4))) ** 2)
            + np.sum(
        (((x[: dim - 1] + 1) / 4) ** 2)
        * (1 + 10 * ((np.sin(math.pi * (1 + (x[1:] + 1) / 4)))) ** 2)
    )
            + ((x[dim - 1] + 1) / 4) ** 2
    ) + np.sum(Ufun(x, 10, 100, 4))
    return o


def F13(x):
    if x.ndim == 1:
        x = x.reshape(1, -1)

    o = 0.1 * (
            (np.sin(3 * np.pi * x[:, 0])) ** 2
            + np.sum(
        (x[:, :-1] - 1) ** 2
        * (1 + (np.sin(3 * np.pi * x[:, 1:])) ** 2), axis=1
    )
            + ((x[:, -1] - 1) ** 2) * (1 + (np.sin(2 * np.pi * x[:, -1])) ** 2)
    ) + np.sum(Ufun(x, 5, 100, 4))
    return o


def F14(x):
    aS = [
        [
            -32, -16, 0, 16, 32,
            -32, -16, 0, 16, 32,
            -32, -16, 0, 16, 32,
            -32, -16, 0, 16, 32,
            -32, -16, 0, 16, 32,
        ],
        [
            -32, -32, -32, -32, -32,
            -16, -16, -16, -16, -16,
            0, 0, 0, 0, 0,
            16, 16, 16, 16, 16,
            32, 32, 32, 32, 32,
        ],
    ]
    aS = np.asarray(aS)
    bS = np.zeros(25)
    v = np.matrix(x)
    for i in range(0, 25):
        H = v - aS[:, i]
        bS[i] = np.sum((np.power(H, 6)))
    w = [i for i in range(25)]
    for i in range(0, 24):
        w[i] = i + 1
    o = ((1.0 / 500) + np.sum(1.0 / (w + bS))) ** (-1)
    return o


def F15(L):
    aK = [
        0.1957, 0.1947, 0.1735, 0.16, 0.0844, 0.0627,
        0.0456, 0.0342, 0.0323, 0.0235, 0.0246,
    ]
    bK = [0.25, 0.5, 1, 2, 4, 6, 8, 10, 12, 14, 16]
    aK = np.asarray(aK)
    bK = np.asarray(bK)
    bK = 1 / bK
    fit = np.sum(
        (aK - ((L[0] * (bK ** 2 + L[1] * bK)) / (bK ** 2 + L[2] * bK + L[3]))) ** 2
    )
    return fit


def F16(L):
    o = (
            4 * (L[0] ** 2)
            - 2.1 * (L[0] ** 4)
            + (L[0] ** 6) / 3
            + L[0] * L[1]
            - 4 * (L[1] ** 2)
            + 4 * (L[1] ** 4)
    )
    return o


def F17(L):
    o = (
            (L[1] - (L[0] ** 2) * 5.1 / (4 * (np.pi ** 2)) + 5 / np.pi * L[0] - 6)
            ** 2
            + 10 * (1 - 1 / (8 * np.pi)) * np.cos(L[0])
            + 10
    )
    return o


def F18(L):
    o = (
                1
                + (L[0] + L[1] + 1) ** 2
                * (
                        19
                        - 14 * L[0]
                        + 3 * (L[0] ** 2)
                        - 14 * L[1]
                        + 6 * L[0] * L[1]
                        + 3 * L[1] ** 2
                )
        ) * (
                30
                + (2 * L[0] - 3 * L[1]) ** 2
                * (
                        18
                        - 32 * L[0]
                        + 12 * (L[0] ** 2)
                        + 48 * L[1]
                        - 36 * L[0] * L[1]
                        + 27 * (L[1] ** 2)
                )
        )
    return o


# map the inputs to the function blocks
def F19(L):
    aH = [[3, 10, 30], [0.1, 10, 35], [3, 10, 30], [0.1, 10, 35]]
    aH = np.asarray(aH)
    cH = [1, 1.2, 3, 3.2]
    cH = np.asarray(cH)
    pH = [
        [0.3689, 0.117, 0.2673],
        [0.4699, 0.4387, 0.747],
        [0.1091, 0.8732, 0.5547],
        [0.03815, 0.5743, 0.8828],
    ]
    pH = np.asarray(pH)
    o = 0
    for i in range(0, 4):
        o = o - cH[i] * np.exp(-(np.sum(aH[i, :] * ((L - pH[i, :]) ** 2))))
    return o


def F20(L):
    aH = [
        [10, 3, 17, 3.5, 1.7, 8],
        [0.05, 10, 17, 0.1, 8, 14],
        [3, 3.5, 1.7, 10, 17, 8],
        [17, 8, 0.05, 10, 0.1, 14],
    ]
    aH = np.asarray(aH)
    cH = [1, 1.2, 3, 3.2]
    cH = np.asarray(cH)
    pH = [
        [0.1312, 0.1696, 0.5569, 0.0124, 0.8283, 0.5886],
        [0.2329, 0.4135, 0.8307, 0.3736, 0.1004, 0.9991],
        [0.2348, 0.1415, 0.3522, 0.2883, 0.3047, 0.6650],
        [0.4047, 0.8828, 0.8732, 0.5743, 0.1091, 0.0381],
    ]
    pH = np.asarray(pH)
    o = 0
    for i in range(0, 4):
        o = o - cH[i] * np.exp(-(np.sum(aH[i, :] * ((L - pH[i, :]) ** 2))))
    return o


def F21(L):
    aSH = [
        [4, 4, 4, 4],
        [1, 1, 1, 1],
        [8, 8, 8, 8],
        [6, 6, 6, 6],
        [3, 7, 3, 7],
        [2, 9, 2, 9],
        [5, 5, 3, 3],
        [8, 1, 8, 1],
        [6, 2, 6, 2],
        [7, 3.6, 7, 3.6],
    ]
    cSH = [0.1, 0.2, 0.2, 0.4, 0.4, 0.6, 0.3, 0.7, 0.5, 0.5]
    aSH = np.asarray(aSH)
    cSH = np.asarray(cSH)
    fit = 0
    for i in range(5):
        v = np.matrix(L - aSH[i, :])
        fit = fit - ((v) * (v.T) + cSH[i]) ** (-1)
    o = fit.item(0)
    return o


def F22(L):
    aSH = [
        [4, 4, 4, 4],
        [1, 1, 1, 1],
        [8, 8, 8, 8],
        [6, 6, 6, 6],
        [3, 7, 3, 7],
        [2, 9, 2, 9],
        [5, 5, 3, 3],
        [8, 1, 8, 1],
        [6, 2, 6, 2],
        [7, 3.6, 7, 3.6],
    ]
    cSH = [0.1, 0.2, 0.2, 0.4, 0.4, 0.6, 0.3, 0.7, 0.5, 0.5]
    aSH = np.asarray(aSH)
    cSH = np.asarray(cSH)
    fit = 0
    for i in range(7):
        v = np.matrix(L - aSH[i, :])
        fit = fit - ((v) * (v.T) + cSH[i]) ** (-1)
    o = fit.item(0)
    return o


def F23(L):
    aSH = [
        [4, 4, 4, 4],
        [1, 1, 1, 1],
        [8, 8, 8, 8],
        [6, 6, 6, 6],
        [3, 7, 3, 7],
        [2, 9, 2, 9],
        [5, 5, 3, 3],
        [8, 1, 8, 1],
        [6, 2, 6, 2],
        [7, 3.6, 7, 3.6],
    ]
    cSH = [0.1, 0.2, 0.2, 0.4, 0.4, 0.6, 0.3, 0.7, 0.5, 0.5]
    aSH = np.asarray(aSH)
    cSH = np.asarray(cSH)
    fit = 0
    for i in range(10):
        v = np.matrix(L - aSH[i, :])
        fit = fit - ((v) * (v.T) + cSH[i]) ** (-1)
    o = fit.item(0)
    return o


def getFunctionDetails(a):
    # [name, lb, ub, dim]
    param = {
        "F1": ["F1", -100, 100, 30],
        "F2": ["F2", -10, 10, 30],
        "F3": ["F3", -100, 100, 30],
        "F4": ["F4", -100, 100, 30],
        "F5": ["F5", -30, 30, 30],
        "F6": ["F6", -100, 100, 30],
        "F7": ["F7", -1.28, 1.28, 30],
        "F8": ["F8", -500, 500, 30],
        "F9": ["F9", -5.12, 5.12, 30],
        "F10": ["F10", -32, 32, 30],
        "F11": ["F11", -600, 600, 30],
        "F12": ["F12", -50, 50, 30],
        "F13": ["F13", -50, 50, 30],
        "F14": ["F14", -65.536, 65.536, 2],
        "F15": ["F15", -5, 5, 4],
        "F16": ["F16", -5, 5, 2],
        "F17": ["F17", -5, 15, 2],
        "F18": ["F18", -2, 2, 2],
        "F19": ["F19", 0, 1, 3],
        "F20": ["F20", 0, 1, 6],
        "F21": ["F21", 0, 10, 4],
        "F22": ["F22", 0, 10, 4],
        "F23": ["F23", 0, 10, 4],
    }
    return param.get(a, "nothing")


'''
# ESAs space mission design benchmarks https://www.esa.int/gsp/ACT/projects/gtop/
from fcmaes.astro import (
    MessFull,
    Messenger,
    Gtoc1,
    Cassini1,
    Cassini2,
    Rosetta,
    Tandem,
    Sagas,
)
def Ca1(x):
    return Cassini1().fun(x)
def Ca2(x):
    return Cassini2().fun(x)
def Ros(x):
    return Rosetta().fun(x)
def Tan(x):
    return Tandem(5).fun(x)
def Sag(x):
    return Sagas().fun(x)
def Mef(x):
    return MessFull().fun(x)
def Mes(x):
    return Messenger().fun(x)
def Gt1(x):
    return Gtoc1().fun(x)

def getFunctionDetails(a):
    # [name, lb, ub, dim]
    param = {
        "F1": ["F1", -100, 100, 30],
        "F2": ["F2", -10, 10, 30],
        "F3": ["F3", -100, 100, 30],
        "F4": ["F4", -100, 100, 30],
        "F5": ["F5", -30, 30, 30],
        "F6": ["F6", -100, 100, 30],
        "F7": ["F7", -1.28, 1.28, 30],
        "F8": ["F8", -500, 500, 30],
        "F9": ["F9", -5.12, 5.12, 30],
        "F10": ["F10", -32, 32, 30],
        "F11": ["F11", -600, 600, 30],
        "F12": ["F12", -50, 50, 30],
        "F13": ["F13", -50, 50, 30],
        "F14": ["F14", -65.536, 65.536, 2],
        "F15": ["F15", -5, 5, 4],
        "F16": ["F16", -5, 5, 2],
        "F17": ["F17", -5, 15, 2],
        "F18": ["F18", -2, 2, 2],
        "F19": ["F19", 0, 1, 3],
        "F20": ["F20", 0, 1, 6],
        "F21": ["F21", 0, 10, 4],
        "F22": ["F22", 0, 10, 4],
        "F23": ["F23", 0, 10, 4],
        "Ca1": [
            "Ca1",
            Cassini1().bounds.lb,
            Cassini1().bounds.ub,
            len(Cassini1().bounds.lb),
        ],
        "Ca2": [
            "Ca2",
            Cassini2().bounds.lb,
            Cassini2().bounds.ub,
            len(Cassini2().bounds.lb),
        ],
        "Gt1": ["Gt1", Gtoc1().bounds.lb, Gtoc1().bounds.ub, len(Gtoc1().bounds.lb)],
        "Mes": [
            "Mes",
            Messenger().bounds.lb,
            Messenger().bounds.ub,
            len(Messenger().bounds.lb),
        ],
        "Mef": [
            "Mef",
            MessFull().bounds.lb,
            MessFull().bounds.ub,
            len(MessFull().bounds.lb),
        ],
        "Sag": ["Sag", Sagas().bounds.lb, Sagas().bounds.ub, len(Sagas().bounds.lb)],
        "Tan": [
            "Tan",
            Tandem(5).bounds.lb,
            Tandem(5).bounds.ub,
            len(Tandem(5).bounds.lb),
        ],
        "Ros": [
            "Ros",
            Rosetta().bounds.lb,
            Rosetta().bounds.ub,
            len(Rosetta().bounds.lb),
        ],
    }
    return param.get(a, "nothing")
'''
