
import random
import time
from fractions import Fraction

import numpy
import matplotlib.pyplot as plt
import All_Progs

from All_Progs.map_library import *

def sigmoid(x,A,C):
    z = 1 / (1 + numpy.exp(-A* (x-C)))
    return z

def CrossOver(X1,X2,X3):
    r = random.random()
    y = 0
    if r < 0.333:
        y = X1
    elif r < 0.6666:
        y = X2
    else:
        y = X3
    return y


def Gauss_Function(x, Gauss_Shift):
	Gauss_Output = numpy.exp(-0.5 * ((x - Gauss_Shift) / 1) ** 2)
	return Gauss_Output


def Sigmoid_Function(x, Parameters, a):
	y = sigmoid(x, Parameters[0], Parameters[1]) + (a / 5) * (Gauss_Function(x, 0) - Gauss_Function(x, 2))
	return y


def Power_Function(x, Power_Param_Vector, a):
	c1 = Power_Param_Vector[1]
	c2 = Power_Param_Vector[2]
	c3 = Power_Param_Vector[3]
	c4 = Power_Param_Vector[4]
	
	y = ((x - c3) / c1) ** c2 + c4 + (a / 5) * (Gauss_Function(x, 0) - Gauss_Function(x, 2))
	return y


def Create_Parameters_Ternary_GWO():
	power_for_a = 1
	OptionMap = 'Sigmoid'   # 'Power' 'Sigmoid'
	OptionBinary = 0
	return power_for_a, OptionMap, OptionBinary


def Ternary_Map_Old(y, a, OptionMap, OptionBinary):
	Rand_Value = random.random()
	[power_for_a, OptionMap, OptionBinary] = Create_Parameters_Ternary_GWO()
	
#	if OptionBinary == 1:
#		OptionMap = 'Sigmoid'   # Sigmoid
	
	if OptionMap == 'Power':
		
		Power_Param_Vector_down = numpy.array([2, 3, 0, 0])
		Power_Param_Vector_up = numpy.array([2, 3, 2, 1])
		Phidown = Power_Function(y, Power_Param_Vector_down, a)
		Phiup = Power_Function(y, Power_Param_Vector_up, a)
	
	elif OptionMap == 'Sigmoid':
		
		Slope = 10
		Middle_Value = 1
		if OptionBinary == 1:
			Delta = 0
		else:
			Delta = 0.25
		
		Sigmoid_Param_Vector_down = numpy.array([Slope, Middle_Value + Delta])
		Sigmoid_Param_Vector_up = numpy.array([Slope, Middle_Value - Delta])
		
		Phidown = Sigmoid_Function(y, Sigmoid_Param_Vector_down, a)
		Phiup = Sigmoid_Function(y, Sigmoid_Param_Vector_up, a)
	
	if Rand_Value >= Phiup:
		out = 0
	elif (Rand_Value < Phiup) and (Rand_Value >= Phidown):
		out = 1
	elif Rand_Value < Phidown:
		out = 2
	
#	if OptionBinary == 1:
#		out[out == 2] = 1
	
	return out


def Ternary_Map(y, a, OptionMap, OptionBinary):
	Rand_Value = random.random()

	Slope = 10
	Middle_Value = 1
	#Delta = 0.45
	Delta = 1.0+(a/40) # from 1 to 0.5 # 1.9

	Phidown = sigmoid(y, Slope, Middle_Value + Delta) + (a / 5) * (Gauss_Function(y, 0) - Gauss_Function(y, 2))
	Phiup = sigmoid(y, Slope, Middle_Value - Delta) + (a / 5) * (Gauss_Function(y, 0) - Gauss_Function(y, 2))

	if Rand_Value >= Phiup:
		out = 1#0
	elif (Rand_Value < Phiup) and (Rand_Value >= Phidown):
		out = 0#1
	elif Rand_Value < Phidown:
		out = 1#2
	else:
		out=0 #default, never happens

	return out


def Compute_Leader_Contribution(Positionsij, Leader_posj, a):
	r1 = random.random()  # r1 is a random number in [0,1]
	r2 = random.random()  # r2 is a random number in [0,1]
	
	Al = 2 * a * r1 - a  # Equation (3.3)
	Cl = 2 * r2  # Equation (3.4)
	
	D_l = abs(Cl * Leader_posj - Positionsij)  # Equation (3.5)-part 1
	y_l = Leader_posj - Al * D_l  # Equation (3.6)-part 1
	
	return y_l


def Leader_Selection_and_Contribution(Alpha_pos_value, Beta_pos_value, Delta_pos_value, Random1_pos_value,
									  Random2_pos_value, Positionsij, a):
	##Leader_posj=Select_Leader(Alpha_pos_value,Beta_pos_value,Delta_pos_value,Random1_pos_value,Random2_pos_value,a)
	# pas utilisé au final car temps de calcul élevé
	
	Leader_posj = (Alpha_pos_value+(1-a/2)*Beta_pos_value + (a/2)*Delta_pos_value)/2
	# Avant:
	#Leader_posj = Alpha_pos_value

	y_l = Compute_Leader_Contribution(Positionsij, Leader_posj, a)
	return y_l


def Update_Position_TGWO(Alpha_posj, Beta_posj, Delta_posj, Random1_posj, Random2_posj, Positionsij, a, OptionMap,
						 OptionBinary):
	y_l1 = Leader_Selection_and_Contribution(Alpha_posj, Beta_posj, Delta_posj, Random1_posj, Random2_posj, Positionsij,
											 a)
	#y_l2 = Leader_Selection_and_Contribution(Alpha_posj, Beta_posj, Delta_posj, Random1_posj, Random2_posj, Positionsij,
	#										 a)
	
	#Whole_Leader_Contribution = (y_l1 + y_l2) / 2
	Whole_Leader_Contribution = y_l1

	Positionsij = Ternary_Map(Whole_Leader_Contribution, a, OptionMap, OptionBinary)
	
	return Positionsij


