import numpy as np
import pandas as pd
import pyforest
import cv2

pyforest.active_imports()


def My_Vector(mini, maxi, step):
    # Defines vector [mini:step:maxi]
    # where mini and maxi are included.

    # x=range(mini,maxi,step)
    # x=squeeze()
    # list(x)
    # x = [x for x in range(mini,maxi,step)]

    x1 = np.arange(mini, maxi + step, step)

    Nbelements = x1.shape[0]
    x = x1.reshape((Nbelements, 1))  # for a columnwise vector
    # print('x')
    # print(x)
    return x


def PrintMatSize(Mat):
    Nbrows = np.size(Mat, axis=0)
    Nbcols = np.size(Mat, axis=1)
    print([Nbrows, Nbcols])
    return None


def MatProduct(Mat, vector):
    # Matrix product Mat*vector
    # where vector is a column vector

    # Ne pas confondre avec * qui est un produit point à point
    Product = np.dot(Mat, vector)
    return Product


"""
# Fonctions d'affichage
"""


def PlotSignal(Signal):
    # function without output

    Index = [Index for Index in range(np.size(Signal))]
    plt.plot(Index, Signal, '-')
    # plt.title("real part visualization")
    plt.show()
    plt.savefig("/Images/Signals.png", bbox_inches='tight')
    return None


def PlotTwoSignals(Signal1, Signal2):
    Index = [Index for Index in range(np.size(Signal1))]
    plt.plot(Index, Signal1, Index, Signal2)
    # plt.title("real part visualization")
    plt.show()
    return None


def WriteImage(img, File_Name):
    imgdisp = 255 * (1 - img / np.max(np.squeeze(img)))
    cv2.imwrite(File_Name, imgdisp)
    return None


"""
# Fonctions de chargement uo de création d'une image
"""


def to_grayscale(im, weights=np.c_[1 / 3, 1 / 3, 1 / 3]):
    """
    Transforms a colour image to a greyscale image by
    taking the mean of the RGB values, weighted
    by the matrix weights
    """
    tile = np.tile(weights, reps=(im.shape[0], im.shape[1], 1))
    return np.sum(tile * im, axis=2)


def square_img(img, pad_value=0):
    """ Square image by padding smallest dimension with pad_value
    # Arguments
      :param img: numpy array, image
      :param pad_value: int, padding value (default: 0)
    # Returns
      :return new_img: numpy array, squared image
    """
    w, h = img.shape[:-1]
    if w > h:
        t = (w - h) // 2
        new_img = np.ones((w, w, img.shape[2]), dtype=img.dtype) * pad_value
        new_img[:, t:h + t] = img
    elif w < h:
        t = (h - w) // 2
        new_img = np.ones((h, h, img.shape[2]), dtype=img.dtype) * pad_value
        new_img[t:w + t] = img
    else:
        new_img = img
    return new_img


def load_padding_resize(file_name, h, w):
    """ Load, square by padding with mean & resize an image with CV2
    # Arguments
      :param file_name: str, file name (with path & extension)
      :param h: int, height
      :param w: int, width
    # Returns
      :return img: numpy array, final image
    """
    img = cv2.imread(file_name)
    img = 1 - (to_grayscale(img) / 255)

    # print('img max',np.max(img))
    # print('img min',np.min(img))

    Sum1 = np.sum(img, axis=1)
    Sum2 = np.sum(Sum1, axis=0)
    # print('img sum',Sum2)

    # img=img/ img.max

    # opencv rend directement l'image sous la forme d'un numpy array.
    # img = cv2.resize(square_img(img, img.mean()), (h, w))#, interpolation=INTER_LINEAR
    return img


def createArtificialImage(h, w):
    # h: number of rows
    # w: number of columns

    img = np.zeros((h, w))

    ampl = 0 * np.linspace(0.2, 1.2, h)
    ampl = ampl.reshape((h, 1))
    per = 30

    X0 = Compute_InitializationVector(h)
    Deltax = ampl * np.sin(My_Vector(0, h - 1, 1) * np.pi / per)

    print(Deltax[1])

    ind = 0
    while ind < h:
        col = np.int(np.ceil(X0[ind] + Deltax[ind]))
        img[ind, col] = 1
        ind = ind + 1

    img = Add_Noise("gauss", img)
    # Sum1=np.sum(img, axis=1)
    # Sum2=np.sum(Sum1, axis=0)
    # print('img sum',Sum2)
    WriteImage(img, '/Images/Processed_Image.jpg')
    return img


"""
# Fonction ajout de bruit
"""


def Add_Noise(noise_typ, image):
    if noise_typ == "gauss":
        row, col = image.shape
        mean = 0.00000
        var = 0.000000
        sigma = var ** 0.5
        gauss = np.random.normal(mean, sigma, (row, col))
        gauss = gauss.reshape(row, col)
        noisy = image + gauss
        return noisy
    elif noise_typ == "s&p":
        row, col = image.shape
        s_vs_p = 0.05
        amount = 0.04
        out = np.copy(image)
        # Salt mode
        num_salt = np.ceil(amount * image.size * s_vs_p)
        coords = [np.random.randint(0, i - 1, int(num_salt))
                  for i in image.shape]
        out[coords] = 1

        # Pepper mode
        num_pepper = np.ceil(amount * image.size * (1. - s_vs_p))
        coords = [np.random.randint(0, i - 1, int(num_pepper))
                  for i in image.shape]
        out[coords] = 0
        return out
    elif noise_typ == "poisson":
        vals = len(np.unique(image))
        vals = 2 ** np.ceil(np.log2(vals))
        noisy = np.random.poisson(image * vals) / float(vals)
        return noisy
    elif noise_typ == "speckle":
        row, col = image.shape
        gauss = np.random.randn(row, col)
        gauss = gauss.reshape(row, col)
        noisy = image + image * gauss
        return noisy


"""
# Fonction de création d'un signal à partir d'une matrice
# schéma de propagation à vitesse constante 
"""


def DefineMu():
    # function without input
    Mu = 5 * 10 ** -3
    return Mu


def FourierWeightVector(Nbrows, Mu):
    # ic=sqrt(-1)
    ic = complex(0, 1)
    Angle = My_Vector(1, Nbrows, 1)
    FWeights = np.exp(-ic * Mu * Angle)
    # print('Size FWeights')
    # print(np.size(FWeights))
    return FWeights


def Compute_Generated_Signal_From_Image(img, Mu):
    # Nbrowsimage=np.size(img,axis=0)
    Nbcolsimage = np.size(img, axis=1)

    # print('size img')
    # PrintMatSize(img)

    NbrowsVector = Nbcolsimage
    FWeights = FourierWeightVector(NbrowsVector, Mu)
    # print('size FWeights')
    # PrintMatSize(FWeights)
    # print(np.real(FWeights))

    GeneratedSignal = MatProduct(img, FWeights)  # FWeights
    # print('size GeneratedSignal')
    # PrintMatSize(GeneratedSignal)
    RetrievedAngle = np.angle(GeneratedSignal) / (-Mu)
    print(RetrievedAngle)

    # RetrievedAbs=np.abs(GeneratedSignal)
    # print(RetrievedAngle)

    ### Plot of the generated signal
    # PlotSignal(RetrievedAngle)
    return GeneratedSignal


def Two_Dimensional_Image_Interpolation(image, Interpolation_Factor):
    Interpolation_Factor_Rows = int(np.sqrt(Interpolation_Factor))
    Interpolation_Factor_Cols = int(np.sqrt(Interpolation_Factor))

    output_image = cv2.resize(image, None, fx=Interpolation_Factor_Rows, fy=Interpolation_Factor_Cols,
                              interpolation=cv2.INTER_LINEAR)

    # output_image=np.interp2D(image)
    return output_image
